package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by hong
 * time 2023/8/21.
 */
@Data
public class MoYiBidRequest {
    @JsonProperty("request_id")
    private String requestId;

    private List<Imp> imp;

    private Device device;

    private App app;

    private User user;
    @JsonProperty("gx_caid")
    private GxCaid gxCaid;
    private Geo geo;

    @JsonProperty("at")
    private int auctionType;
    @Data
    public class Imp {

        private String id;

        private String tagid;

        @JsonProperty("bid_floor")
        private int bidFloor;

        @JsonProperty("ad_types")
        private List<Integer> adTypes;

        private Integer w;

        private Integer h;


    }
    @Data
    public class Device {

        private String ua;

        @JsonProperty("webview_ua")
        private String webViewUa;

        private String ip;

        @JsonProperty("ipv6")
        private String ipV6;

        private Geo geo;

        @JsonProperty("make")
        private String make;

        private String brand;

        @JsonProperty("device_type")
        private int deviceType;

        private String model;

        private int width;

        private int height;

        private String os;

        private String osv;

        private int ppi;

        private int dpi;

        @JsonProperty("connection_type")
        private int connectionType;

        private int carrier;

        @JsonProperty("android_id")
        private String androidId;

        @JsonProperty("android_id_md5")
        private String androidIdMd5;

        private String idfa;

        @JsonProperty("idfa_md5")
        private String idfaMd5;

        @JsonProperty("oaid")
        private String oaid;

        @JsonProperty("oaid_md5")
        private String oaidMd5;

        private String imei;

        @JsonProperty("imei_md5")
        private String imeiMd5;

        private String mac;

        @JsonProperty("mac_md5")
        private String macMd5;

        @JsonProperty("boot_mark")
        private String bootMark;

        @JsonProperty("update_mark")
        private String updateMark;

        @JsonProperty("startup_time")
        private String startupTime;

        @JsonProperty("mb_time")
        private String mbTime;

        @JsonProperty("wifi_ssid")
        private String wifiSsid;

        @JsonProperty("wifi_mac")
        private String wifiMac;

        @JsonProperty("mem_total")
        private int memTotal;

        @JsonProperty("disk_total")
        private int diskTotal;

        @JsonProperty("model_type")
        private String modelType;

        @JsonProperty("country_code")
        private String countryCode;

        private String language;

        @JsonProperty("phone_name")
        private String phoneName;

        @JsonProperty("hwmachine")
        private String hwMachine;

        @JsonProperty("local_tz_time")
        private String localTzTime;


    }
    @Data
    public class User {

        private String gender;

        private int yob;

        private int age;


    }
    @Data
    public class Geo {

        private float lat;

        private float lon;

        private String city;


    }
    @Data
    public class GxCaid {

        private String id;

        @JsonProperty("id_md5")
        private String idMd5;

        @JsonProperty("generate_time")
        private int generateTime;

        private int version;

        private int vendor;


    }
    @Data
    public class App {

        private String name;

        @JsonProperty("package_name")
        private String packageName;

        @JsonProperty("installed_client_apps")
        private List<String> installedClientApps;

        private String ver;


    }
}
