package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by hong
 * time 2023/8/21.
 */
@Data
public class MoYiBidResponse {

    private String id;

    @JsonProperty("seat_bid")
    private List<SeatBid> seatBids;


    @Data
    public class SeatBid {

        private List<Bid> bids;


    }

    @Data
    public class Bid {

        private String id;

        @JsonProperty("imp_id")
        private String impId;

        private float price;

        private Ext ext;


    }

    @Data
    public class Ext {

        private Material material;

        private Tracking tracking;


    }

    @Data
    public class Material {

        @JsonProperty("ad_type")
        private int adType;

        private String icon;

        private List<Image> images;

        private String title;

        private String desc;

        private List<Video> video;

        @JsonProperty("download_type")
        private int downloadType;

        private String ldp;

        private String durl;

        @JsonProperty("download_url")
        private String downloadUrl;

        @JsonProperty("package")
        private String packageName;

        @JsonProperty("itunes_id")
        private String itunesId;

        @JsonProperty("app_info")
        private AppInfo appInfo;


    }

    @Data
    public class Image {

        private String url;

        private String width;

        private String height;


    }

    @Data
    public class AppInfo {

        private String name;

        @JsonProperty("icon_url")
        private String iconUrl;

        @JsonProperty("download_url")
        private String downloadUrl;

        private int size;

        @JsonProperty("version_name")
        private String versionName;

        @JsonProperty("package_name")
        private String packageName;

        private String developer;

        @JsonProperty("permission_url")
        private String permissionUrl;

        @JsonProperty("privacy_url")
        private String privacyUrl;

        private String description;


    }
    @Data
    public class Video {

        private String videoImg;

        @JsonProperty("vurl")
        private String videoUrl;

        private int width;

        private int height;

        private int duration;

        @JsonProperty("video_title")
        private String videoTitle;

        // getter和setter方法

    }


    @Data
    public class Tracking {

        private List<String> pnurl;

        @JsonProperty("report_impress")
        private List<String> reportImpress;

        @JsonProperty("report_click")
        private List<String> reportClick;

        @JsonProperty("report_other")
        private List<ReportOther> reportOther;


    }

    @Data
    public class ReportOther {

        private int type;

        private List<String> urls;


    }
}
