package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean.BuLuKenBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.CarrierConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.ConnectionTypeConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.OsConvert;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class MoYiRequestConvert {

    public MoYiBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MoYiBidRequest builder = new MoYiBidRequest();
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setAuctionType(adxCommonBidRequest.getAt());
        convertImp(builder,adxCommonBidRequest, dspInfo);
        convertApp(builder,adxCommonBidRequest, dspInfo);
        convertDevice(builder,adxCommonBidRequest);
        return builder;
    }

    public  void convertImp(MoYiBidRequest builder, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {

        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);

        MoYiBidRequest.Imp imp = new MoYiBidRequest().new Imp();
        imp.setId(commonImp.getId());
        imp.setBidFloor((int) Math.round(commonImp.getFloorPrice()));
        imp.setTagid(commonImp.getTagId());
        imp.setAdTypes(commonImp.getContentTypes());

        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        imp.setW(commonSizeInfo.getWidth());
        imp.setH(commonSizeInfo.getHeight());
    }

    public  final String ANDROID = "0";
    public  final String IOS = "1";

    public String getOsType(String os) {
        if (StringUtils.isBlank(os)) {
            return "unknown";
        }
        switch (os) {
            case ANDROID:
                return "Android";
            case IOS:
                return "iOS";
            default:
                return "unknown";
        }
    }
    //移动
    public static final String MOVE = "1";
    //联通
    public static final String UNICOM = "2";
    //电信
    public static final String TELECOM = "3";

    public Integer getCarrierType(String carrier) {
        if(StringUtils.isBlank(carrier)){
            return 0;
        }
        switch (carrier){
            case MOVE:
                return 1;
            case UNICOM:
                return 2;
            case TELECOM:
                return 3;
            default:
                return 0;
        }
    }



    public  void convertDevice(MoYiBidRequest request, AdxCommonBidRequest adxCommonBidRequest) {
        MoYiBidRequest.Device builder= new MoYiBidRequest().new Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setIp(device.getIp());
        builder.setUa(device.getUa());
        builder.setWebViewUa(device.getUa());
        if (StringUtils.isNotEmpty(device.getImeiMd5())) {
            builder.setImeiMd5(StringUtils.upperCase(device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaIdMd5())) {
            builder.setOaidMd5(StringUtils.upperCase(device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty(device.getIdFaMd5())) {
            builder.setIdfaMd5(StringUtils.upperCase(device.getIdFaMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaId())) {
            builder.setOaid(device.getOaId());      }
        builder.setDeviceType(1);
        builder.setBrand(device.getMake());
        builder.setModel(device.getModel());
        builder.setOs(OsConvert.getOsType(device.getOs()));
        builder.setOsv(device.getOsVersion());
        builder.setMake(device.getMake());
        builder.setCarrier(getCarrierType(device.getCarrier()));
        builder.setConnectionType(ConnectionTypeConvert.convertConnectionType(device.getTuiaConnectionType()));
        MoYiBidRequest.Geo geo= new MoYiBidRequest().new Geo();
        geo.setCity(device.getGeo().getCity());
        geo.setLon(device.getGeo().getLon().floatValue());
        geo.setLat(device.getGeo().getLat().floatValue());
        request.setDevice(builder);
        request.getDevice().setGeo(geo);
    }

    public void convertApp(MoYiBidRequest request, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MoYiBidRequest.App builder = new MoYiBidRequest().new App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        builder.setPackageName(appInfo.getBundle());
        builder.setName(appInfo.getName());
        builder.setVer(appInfo.getVersion());
        request.setApp(builder);

    }
}
