package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import com.google.protobuf.ProtocolStringList;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Component
@Slf4j
public class MoYiResponseConvert {
    public AdxCommonBidResponse respConvert(MoYiBidResponse response) {
        if (response == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_7.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response.getSeatBids());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<MoYiBidResponse.SeatBid> seatList) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        if(CollectionUtils.isEmpty(seatList)){
            MoYiBidResponse.SeatBid seatBid = seatList.get(0);
            if(CollectionUtils.isEmpty(seatBid.getBids())){
                MoYiBidResponse.Bid bid = seatBid.getBids().get(0);
                MoYiBidResponse.Ext ext = bid.getExt();
                if(Objects.nonNull(ext)){
                    MoYiBidResponse.Material material = ext.getMaterial();
                    if(Objects.nonNull(material)){
                        CommonCreative commonCreative = new CommonCreative();
                        commonSeatBid.setCommonCreative(commonCreative);


                        commonSeatBid.setPrice(Double.parseDouble(String.valueOf(bid.getPrice())));
                        commonSeatBid.setAdvertiserId("");//todo ?

                        if(Objects.nonNull(ext.getTracking())){
                            MoYiBidResponse.Tracking tracking = ext.getTracking();
                            commonSeatBid.setWinCallbackUrls(tracking.getPnurl());
                            commonSeatBid.setExposureCallbackUrls(tracking.getReportImpress());
                            commonSeatBid.setClickCallbackUrls(tracking.getReportClick());
                        }

                        commonCreative.setLandingPageUrl(material.getLdp());
                        commonCreative.setCreativeId(bid.getId());
                        commonCreative.setDeepLinkUrl(material.getDurl());
                        context.setDeepLinkUrl(material.getDurl());

                        CommonTitle commonTitle = new CommonTitle();
                        commonTitle.setTitle(material.getTitle());
                        commonCreative.setCommonTitle(commonTitle);
                        //标题当描述特殊处理
                        CommonDesc commonDesc = new CommonDesc();
                        commonDesc.setDesc(material.getDesc());
                        commonCreative.setCommonDesc(commonDesc);

                        if (Objects.equals(material.getAdType() , 1)) {
                            List<CommonImage> imageList = new ArrayList<>();
                            CommonImage image = new CommonImage();
                            List<MoYiBidResponse.Image> images = material.getImages();
                            if(CollectionUtils.isNotEmpty(images)){
                                MoYiBidResponse.Image image1 = images.get(0);
                                image.setUrl(image1.getUrl());
                                image.setWidth(Integer.valueOf(StringUtils.isNotBlank(image1.getWidth())?image1.getWidth():"0"));
                                image.setHeight(Integer.valueOf(StringUtils.isNotBlank(image1.getHeight())?image1.getWidth():"0"));
                            }


                            imageList.add(image);
                            commonCreative.setCommonImageList(imageList);
                        }
                        if (Objects.equals(material.getAdType() , 2)) {
                            List<CommonVideo> videoList = new ArrayList<>();
                            CommonVideo video = new CommonVideo();
                            List<MoYiBidResponse.Video> videos = material.getVideo();
                            if(CollectionUtils.isNotEmpty(videos)){
                                MoYiBidResponse.Video video1 = videos.get(0);
                                video.setVideoUrl(video1.getVideoUrl());
                                video.setCoverUrl(video1.getVideoImg());
                                video.setDuration(BigDecimal.valueOf(video1.getDuration()));
                            }


                            videoList.add(video);
                            commonCreative.setCommonVideoList(videoList);
                        }



                    }
                }
            }
        }








        return commonSeatBidList;
    }
}
