package cn.com.duiba.tuia.dsp.engine.api.filter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.tuia.advert.adxService.AdxEngineService;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2022/11/28
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class BudgetConditionFilter implements AdvertConditionFilter{

    @Autowired
    private AdxEngineService adxEngineService;

    @Override
    public boolean match(DspInfo dspInfo) {
        Long advertId = dspInfo.getAdvertId();
        if(Objects.isNull(advertId)){
            SamplerLog.info("BudgetConditionFilter.match advertId is null");
            return false;
        }
        try {
            Boolean validate = adxEngineService.outDspBudgetValidInfo(advertId);
            if(!validate){
                SamplerLog.info("BudgetConditionFilter 广告已经失效advertId:{}", advertId);
            }
            return validate;
        }catch (Exception e){
            SamplerLog.warn("BudgetConditionFilter error, dspInfo:{}", JSON.toJSONString(dspInfo), e);
            return false;
        }
    }
}
