package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;


/**
 * 门面接口
 *
 * @author lizhiheng
 */
public abstract class DspFacadeInterface {

    @Autowired
    protected RestTemplate restTemplate;

    /**
     * 调用DSP接口的门面方法
     * 需要传入公共请求参数和外部dsp接口
     * doInvoke接口做了
     * 1。异步请求所需的外部dsp调用
     * 2。进行比价
     * 3。返回 x
     *
     * @param adxCommonBidRequest
     * @param dspInfos
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     * @throws TimeoutException
     */
    abstract AdxCommonBidResponse doInvoke(AdxCommonBidRequest adxCommonBidRequest, List<DspInfo> dspInfos) throws ExecutionException, InterruptedException, TimeoutException;

    /**
     * 比价方法，
     *
     * @param responseList
     * @return
     */
    protected AdxCommonBidResponse comparePrice(List<AdxCommonBidResponse> responseList) {
        if (Objects.isNull(responseList) || responseList.isEmpty()) {
            return null;
        }
        AtomicReference<AdxCommonBidResponse> adxCommonBidResponse = new AtomicReference<>();
        responseList.stream()
                .filter(Objects::nonNull)
                // FIXME: 2022/7/8 这里可能会有NPE问题，稍后测试的时候修复
                .max((res1, res2) -> (int) (res1.getCommonSeatBidList().get(0).getPrice() - res2.getCommonSeatBidList().get(0).getPrice()))
                .ifPresent(adxCommonBidResponse::set);
        return adxCommonBidResponse.get();
    }

    /**
     * 价格加密方法
     *
     * @param price
     * @param dspId
     * @return
     */
    public abstract String priceEncryption(BigDecimal price, Integer dspId);

    /**
     * 宏替换含有价格的url
     * @param price 出价价格
     * @param dspId 外部dsp id
     * @param url 需要替换的url
     * @return
     */
    public abstract String replaceUrl(String price, String url, Integer dspId);

    /**
     * 竞价胜出回调广告主
     * @param url 回调链接
     * @param dspId
     */
    public abstract void doWinCallBack(String url, Integer dspId);

    /**
     * 点击回调广告主
     * @param url 回调链接
     * @param dspId
     */
    public abstract void doClickCallBack(String url, Integer dspId);

    /**
     * 曝光回调广告主
     * @param url 回调链接
     * @param dspId
     */
    public abstract void doExposureCallBack(String url, Integer dspId);

}
