package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import cn.com.duiba.tuia.dsp.engine.api.util.UAUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;

import static cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass.CostType.COSTTYPE_CPM;
import static cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunRequestConverter.appMap;


/**
 * @author lizhiheng
 */
@Component
@Slf4j
public class KuaishouRequestConverter {
    /**
     * 图片类型
     */
    private static final Integer BANNER_TYPTE = 1;
    /**
     * 视频类型
     */
    private static final Integer VIDEO_TYPE = 3;


    public KuaishouBidRequestOuterClass.KuaishouBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Builder builder = KuaishouBidRequestOuterClass.KuaishouBidRequest.newBuilder();
        //设置imp对象
        builder.setImpressions(0, this.convertImp(adxCommonBidRequest, dspInfo));

        //设置device对象
        builder.setId(adxCommonBidRequest.getRequestId());
        builder.setDevice(this.convertDevice(adxCommonBidRequest.getDevice(), adxCommonBidRequest.getAdxType()));
        builder.setIp(optionOfNull(adxCommonBidRequest.getDevice().getIp()));
        //设置user对象
        builder.setGeo(this.convertGeo(adxCommonBidRequest.getDevice().getGeo()));
        //设置app对象
        if (37506 == dspInfo.getIdeaId()) {
            KuaishouBidRequestOuterClass.KuaishouBidRequest.App appInfo = replaceApp(adxCommonBidRequest.getAppInfo());
            builder.setApp(appInfo);
        } else {
            builder.setApp(convertApp(adxCommonBidRequest.getAppInfo(), adxCommonBidRequest.getDevice()));
        }

        return builder.build();
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Device convertDevice(CommonDevice device, Integer adxType) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Device.Builder deviceBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Device.newBuilder();
        if (Objects.isNull(device)) {
            return deviceBuilder.build();
        }
        deviceBuilder.setDeviceType(DeviceTypeConverter.getDeviceType(device.getUa()));
        UAData uaData = UAUtils.parseUA(device.getUa());
        deviceBuilder.setOs(OsConverter.getOsType(device.getOs(), uaData));
        deviceBuilder.setOsVersion(OsvConverter.getOsvType(device.getUa()));
        deviceBuilder.setUserAgent(optionOfNull(device.getUa()));
//        deviceBuilder.setScreenWidth(optionOfNull(device.getUa())); 屏幕宽度
//        deviceBuilder.setScreenHeight(optionOfNull(device.getUa())); 屏幕高度
//        deviceBuilder.setDpi() 每英寸像素
        //运营商 0：unkonwn；1：中国移劢；2：中国联通；3：中国电信
        deviceBuilder.setCarrier(CarrierConverter.getCarrierType(device.getCarrier()));
        deviceBuilder.setConnectionType(ConnectionTypeConverter.getConnectionType(device.getTuiaConnectionType()));
        deviceBuilder.setBrandAndModel(this.getModel(device.getMake(), uaData)); //设备品牌型号
        deviceBuilder.setIdfa(optionOfNull(device.getIdFa()));
        deviceBuilder.setIdfaMd5(optionOfNull(device.getIdFaMd5()));
        deviceBuilder.setManufacturer(this.getMaker(device.getMake(), uaData)); //设备制造商
        deviceBuilder.setOaid(optionOfNull(device.getOaId()));
        deviceBuilder.setOaidMd5(optionOfNull(device.getOaIdMd5()));
        deviceBuilder.setImei(optionOfNull(device.getImei()));
        deviceBuilder.setImeiMd5(optionOfNull(device.getImeiMd5()));
//        deviceBuilder.setInstallAppList() 用户安装app列表
        return deviceBuilder.build();
    }

    private String getModel(String model, UAData uaData) {
        if (StringUtils.isNotBlank(model)) {
            return model;
        }
        if (Objects.nonNull(uaData)) {
            String model1 = uaData.getModel();
            if (StringUtils.isNotBlank(model1)) {
                return model1;
            }
        }
        return " ";
    }

    private String getMaker(String make, UAData uaData) {
        if (StringUtils.isNotBlank(make)) {
            return make;
        }
        if (Objects.nonNull(uaData)) {
            if (Objects.equals("Android", uaData.getOsType())) {
                return "huawei";
            } else {
                return "apple";
            }
        }
        return "unknow";
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo convertGeo(CommonGeo geo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo.Builder geoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo.newBuilder();
        if (Objects.isNull(geo)) {
            return geoBuilder.build();
        }
        Optional.ofNullable(geo.getLat()).ifPresent(lat -> geoBuilder.setLatitude(lat.intValue()));
        Optional.ofNullable(geo.getLon()).ifPresent(leo -> geoBuilder.setLongitude(leo.intValue()));
        // accuracy， 经纬度精度半径没有
        return geoBuilder.build();
    }

    private KuaishouBidRequestOuterClass.KuaishouBidRequest.App replaceApp(CommonAppInfo commonAppInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.App.Builder builder = KuaishouBidRequestOuterClass.KuaishouBidRequest.App.newBuilder();
//        String appId = BlowfishUtils.encryptBlowfish(StringUtils.isBlank(commonAppInfo.getId()) ? "YQFDSG" : commonAppInfo.getId());
        if (appMap.containsKey(commonAppInfo.getBundle())) {
            String bundle = appMap.get(commonAppInfo.getBundle());
            builder.setAppBundleId(bundle);
            return builder.build();
        }
        Random random = new Random();
        int i = random.nextInt(appMap.size());
        String budle = appMap.values().stream().skip(i).findFirst().get();
        builder.setAppBundleId(budle);
        return builder.build();
    }

    private KuaishouBidRequestOuterClass.KuaishouBidRequest.App convertApp(CommonAppInfo appInfo, CommonDevice device) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.App.Builder appInfoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.App.newBuilder();
        if (Objects.nonNull(appInfo)) {
            UAData uaData = UAUtils.parseUA(device.getUa());
            if (Objects.equals(uaData.getOsType(), "Android")) {
                appInfoBuilder.setAppBundleId(appInfo.getBundle());
            }
        } else {
            appInfoBuilder.setAppBundleId("com.tuia");
        }
        return appInfoBuilder.build();
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression.Builder impInfoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression.newBuilder();
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) {
            return impInfoBuilder.build();
        }
        CommonImp commonImp = impList.get(0);
        impInfoBuilder.setId(optionOfNull(commonImp.getId()));
        List<CommonSizeInfo> filteringSize = filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());

        if (CollectionUtils.isNotEmpty(filteringSize)) {
            List<Long> templateIds = Lists.newArrayList();
            if (dspInfo.getDspTagId() != null) {
                impInfoBuilder.setPlacementId(dspInfo.getDspTagId());
            }
            if (dspInfo.getDspTemplateId() != null) {
                templateIds.add(Long.valueOf(dspInfo.getDspTemplateId()));
            }
            impInfoBuilder.addAllTemplateIds(templateIds);
            long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100)) + 1;
            impInfoBuilder.setCpmBidFloor(bidFloor);
//            impInfoBuilder.setCpcBidFloor(bidFloor);// cpc底价
//            impInfoBuilder.setPlacementType(commonImp.getAdSlotType()); //广告位类型
            impInfoBuilder.addSupportCostTypes(COSTTYPE_CPM);// 计费方式
            impInfoBuilder.setAdsCount(1);// 支持返回bid个数
            impInfoBuilder.setSupportDeepLink(commonImp.isOpenDeepLink());// 广告位是否支持deep link
            List<KuaishouBidRequestOuterClass.PromotionType> collect = commonImp.getContentTypes().stream().map(this::convertPromotionType).collect(Collectors.toList());
            impInfoBuilder.addAllPromotionTypes(collect);// 推广类型
//            impInfoBuilder.setIndustryId() // 广告位所属行业类型

            if (CollectionUtils.isEmpty(impInfoBuilder.getTemplateIdsList())) {
                log.warn("未找到对应光告广告位，commonImp", JSON.toJSONString(commonImp));
                return impInfoBuilder.build();
            }

        }
        impInfoBuilder.setId(commonImp.getId());

        return impInfoBuilder.build();
    }

    private KuaishouBidRequestOuterClass.PromotionType convertPromotionType(Integer integer) {
        switch (integer) {
            case 0:
                return KuaishouBidRequestOuterClass.PromotionType.PROMOTION_TYPE_UNKNOWN;
            case 1:
                return KuaishouBidRequestOuterClass.PromotionType.PROMOTION_TYPE_DEEPLINK_DOWNLOAD;
            case 2:
                return KuaishouBidRequestOuterClass.PromotionType.PROMOTION_TYPE_DEEPLINK;
            case 3:
                return KuaishouBidRequestOuterClass.PromotionType.PROMOTION_TYPE_DOWNLOAD;
        }
        return KuaishouBidRequestOuterClass.PromotionType.PROMOTION_TYPE_UNKNOWN;
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        List<CommonSizeInfo> commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (Objects.nonNull(commonSizeInfo1)) {
                commonSizeInfos.add(commonSizeInfo1);
            }

        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (filterMaterInfo.getWidth().equals(width) && filterMaterInfo.getHeight().equals(height)) {
                return commonSizeInfo;
            }
        }
        return null;
    }

    private String optionOfNull(String param) {
        return Optional.ofNullable(param).orElse("");
    }
}
