package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidResponseOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Author kuaishou
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
public class KuaishouResponseConverter {

    public AdxCommonBidResponse respConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_4.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getRequestId());
        List<CommonSeatBid> commonSeatBids = seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse rtbResponse) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        commonSeatBid.setAdvertiserId("44910");// 为何写死
        //设置价格
        if (rtbResponse.getBidsList().isEmpty()) {
            return commonSeatBidList;
        }
        KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid bidResponse = rtbResponse.getBidsList().get(0);
        commonSeatBid.setPrice((double) bidResponse.getBidPrice());
        commonSeatBid.setCommonCreative(creativeConvert(bidResponse.getCreativeDetails()));
        //设置竞价胜出链接
        List<String> winCallbackUrls = new ArrayList<>();
        winCallbackUrls.add(bidResponse.getNoticeUrl());
        commonSeatBid.setWinCallbackUrls(winCallbackUrls);
        //设置曝光链接
        setExposureUrl(commonSeatBid, bidResponse.getImpressionMonitorUrl());
        //设置点击链接
        setClickUrl(commonSeatBid, bidResponse.getClickMonitorUrl());
        commonSeatBid.setCommonContext(commonContextConvert(bidResponse.getCreativeDetails()));
        return commonSeatBidList;
    }

    private void setClickUrl(CommonSeatBid commonSeatBid, String clickList) {
        if (StringUtils.isBlank(clickList)) {
            return;
        }
        commonSeatBid.setClickCallbackUrls(Collections.singletonList(clickList));
    }

    private void setExposureUrl(CommonSeatBid commonSeatBid, String exposureUrl) {
        if (StringUtils.isBlank(exposureUrl)) {
            return;
        }
        commonSeatBid.setExposureCallbackUrls(Collections.singletonList(exposureUrl));
    }

    private CommonContext commonContextConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails creativeDetails) {
        CommonContext commonContext = new CommonContext();
        if (StringUtils.isNotBlank(creativeDetails.getDeepLinkUri())) {
            commonContext.setDeepLinkUrl(creativeDetails.getDeepLinkUri());
        }
        return commonContext;
    }

    private CommonCreative creativeConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails creativeDetails) {
        CommonCreative commonCreative = new CommonCreative();
        setLandPageUrlByAdType(creativeDetails, commonCreative);
        commonCreative.setBrandName("推啊");
        commonCreative.setCommonTitle(convertCommonTitle(creativeDetails.getTitle(), creativeDetails.getTitle()));
        commonCreative.setCommonDesc(commonDescConvert(creativeDetails.getDescription()));
        commonCreative.setCommonIcon(commonIconConvert(creativeDetails.getIcon()));

        commonImageOrVideoConvert(creativeDetails, commonCreative);
        commonCreative.setAppName(creativeDetails.getAppName());
        commonCreative.setAppBundle(creativeDetails.getAppPackage());
        // 没有下载返回体
        Optional.of(creativeDetails.getIcon()).ifPresent(commonCreative::setIconUrl);
        return commonCreative;
    }

    private void setLandPageUrlByAdType(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails rtbResponse, CommonCreative commonCreative) {

        if (commonCreative == null) {
            return;
        }
        commonCreative.setLandingPageUrl(rtbResponse.getLandingPageUrl());
        commonCreative.setDeepLinkUrl(rtbResponse.getDeepLinkUri());
//        commonCreative.setULinkUrl();//

    }

    private void commonImageOrVideoConvert(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails rtbResponse, CommonCreative commonCreative) {
        //图片类型广告
        if (StringUtils.isBlank(rtbResponse.getVideoUrl())) {
            commonCreative.setCommonImageList(convertCommImage(rtbResponse));
        } else {
            commonCreative.setCommonVideoList(convertCommVideo(rtbResponse));
        }
    }

    private List<CommonVideo> convertCommVideo(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails creativeDetail) {

        if (StringUtils.isBlank(creativeDetail.getVideoUrl())) {
            return null;
        }
        List<CommonVideo> commonVideoList = Lists.newArrayList();

        CommonVideo commonVideo = new CommonVideo();
        commonVideo.setVideoUrl(creativeDetail.getVideoUrl());
        commonVideo.setResolutionY(creativeDetail.getVideoHeight());
        commonVideo.setResolutionX(creativeDetail.getVideoWidth());
        commonVideo.setCoverUrl(creativeDetail.getCoverUrl());
        commonVideo.setDuration(new BigDecimal(creativeDetail.getVideoDuration()));
        commonVideoList.add(commonVideo);
        return commonVideoList;
    }

    private List<CommonImage> convertCommImage(KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails rtbResponse) {
        List<KuaishouBidResponseOuterClass.KuaishouBidResponse.Bid.CreativeDetails.image> imagesList = rtbResponse.getImagesList();

        if (CollectionUtils.isEmpty(imagesList)) {
            return null;
        }
        List<CommonImage> commonImageList = Lists.newArrayList();
        imagesList.forEach(image -> {
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image.getImageUrl());
            commonImage.setHeight(image.getImageHeight());
            commonImage.setWidth(image.getImageWidth());
            commonImageList.add(commonImage);
        });
        return commonImageList;
    }

    private CommonIcon commonIconConvert(String iconurl) {
        if (StringUtils.isBlank(iconurl)) {
            return null;
        }
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(iconurl);
        return commonIcon;
    }

    private CommonDesc commonDescConvert(String desc) {
        CommonDesc commonDesc = new CommonDesc();
        commonDesc.setDesc(desc);
        return commonDesc;
    }

    private CommonTitle convertCommonTitle(String title, String desc) {
        CommonTitle commonTitle = new CommonTitle();
        commonTitle.setTitle(title);
        commonTitle.setSubTitle(desc);
        return commonTitle;
    }
}
