package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddDspInvoker;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddTag;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req.*;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lizhiheng
 */
@Component
public class PddReqConverter {

    private static final Logger LOGGER = LoggerFactory.getLogger(PddDspInvoker.class);
    @Resource
    PddProperties dspPddProperties;

    Map<String, String> appMap = new HashMap<>();

    {
        appMap.put("com.sdfsh", "com.safeluck.life");
        appMap.put("com.adhub.app", "com.duorong.smarttool");
        appMap.put("com.jiaxiao", "com.jxedt");
        appMap.put("com.hiyrr", "com.martian.ttbookhd");
        appMap.put("com.eghtht", "com.mendon.riza");
        appMap.put("com.fefe", "com.lishun.flyfish");
        appMap.put("com.ytx.era", "com.itcode.reader");
        appMap.put("com.lehfef", "com.aliyun.iot.living");
        appMap.put("com.dc.lotol", "com.vodone.know");
        appMap.put("com.adhub", "com.snda.lantern.wifilocating");
        appMap.put("com.jo.avi", "com.sevenVideo.app.android");
        appMap.put("com.zhangshang", "com.ichano.athome.camera");
        appMap.put("com.jooa", "com.zlkj.cjszgj");
        appMap.put("com.yy", "com.duowan.mobile");
    }

    public PddRequest reqConvert(AdxCommonBidRequest commonReq, DspInfo dspInfo) {
        PddRequest pddRequest = new PddRequest();
        pddRequest.setAdx_id(dspPddProperties.getAdxId());
        pddRequest.setRequest_id(commonReq.getRequestId());
        pddRequest.setAt(Objects.isNull(commonReq.getAt()) ? 2 : commonReq.getAt());
        List<CommonImp> impList = commonReq.getImpList();

        // 广告位转换
        List<Imp> imps = impList.stream()
                .map(imp -> this.impConvert(imp, dspInfo))
                .collect(Collectors.toList());
        if (imps.isEmpty() || imps.size() == 1 && imps.contains(null)) {
            return null;
        }
        pddRequest.setImp(imps);

        pddRequest.setSite(new Site());
        App app = this.appConvert(commonReq.getAppInfo());
        if (37526L == dspInfo.getIdeaId()) {
            replaceApp(app);
        }
        pddRequest.setApp(app);
        pddRequest.setDevice(this.deviceConvert(commonReq.getDevice()));
        pddRequest.setUser(this.userConvert(commonReq.getUserInfo()));
//        pddRequest.setExt();
        return pddRequest;
    }

    private User userConvert(CommonUserInfo userInfo) {
        User user = new User();
        if (Objects.isNull(userInfo)) {
            return user;
        }
        user.setId(userInfo.getId());
        user.setGender(userInfo.getGender());
//        user.setTag_id();
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> user.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
//        user.setConsume_level();
        return user;
    }

    private Device deviceConvert(CommonDevice commonDevice) {
        Device device = new Device();
        if (Objects.isNull(commonDevice)) {
            return device;
        }
        device.setUa(commonDevice.getUa());
        device.setIp(commonDevice.getIp());
//        device.setIpv6();
        device.setDevicetype(commonDevice.getDeviceType());
        device.setMake(commonDevice.getMake());
        device.setModel(commonDevice.getModel());
        if (StringUtils.isNotBlank(commonDevice.getOs())) {
            if ("0".equals(commonDevice.getOs())) {
                device.setOs("android");
            }
            if ("1".equals(commonDevice.getOs())) {
                device.setOs("ios");
            }
        }
        device.setOsv(commonDevice.getOsVersion());
//        device.setH();
//        device.setW();
        // 这个不设置，因为每个媒体的枚举值都不一样，而且非必须
//        device.setConnectiontype(commonDevice.getConnectionType());
        device.setCarrier(commonDevice.getCarrier());
        device.setImei(commonDevice.getImei());
        device.setImei_md5(commonDevice.getImeiMd5());
//        device.setAndroidid();
//        device.setAndroidid_md5();
        device.setIdfa(commonDevice.getIdFa());
        device.setIdfa_md5(commonDevice.getIdFaMd5());
        device.setOaid(commonDevice.getOaId());
        device.setOaid_md5(commonDevice.getOaIdMd5());
//        device.setCaid();
//        device.setPaid();
        device.setGeo(this.geoConvert(commonDevice.getGeo()));
//        device.setExt();
        return device;

    }

    private Geo geoConvert(CommonGeo commonGeo) {
        Geo geo = new Geo();
        if (Objects.isNull(commonGeo)) {
            return geo;
        }
        Optional.ofNullable(commonGeo.getLat()).ifPresent(lat -> geo.setLatitude(lat.floatValue()));
        Optional.ofNullable(commonGeo.getLon()).ifPresent(leo -> geo.setLongitude(leo.floatValue()));
        return geo;
    }

    private App appConvert(CommonAppInfo appInfo) {
        App app = new App();
        if (Objects.isNull(appInfo)) {
            return app;
        }
        //这里app的信息加密一下 传给pdd
        app.setId(BlowfishUtils.encryptBlowfish(appInfo.getId()));

        app.setName(appInfo.getName());
        app.setBundle(appInfo.getBundle());
        app.setVersion(appInfo.getVersion());
//        app.setApp_scheme("");
        return app;
    }

    //测试替换拼多多包名
    private void replaceApp(App app) {
        if (appMap.containsKey(app.getBundle())) {
            String bundle = appMap.get(app.getBundle());
            app.setBundle(bundle);
            app.setName(app.getId());
            return;
        }
        Random random = new Random();
        int i = random.nextInt(appMap.size());
        String budle = appMap.values().stream().skip(i).findFirst().get();
        app.setBundle(budle);
        app.setName(app.getId());
    }

    public Imp impConvert(CommonImp commonImp, DspInfo dspInfo) {
        Imp imp = new Imp();
        if (Objects.isNull(commonImp)) {
            return null;
        }
        ArrayList<Template> templates = new ArrayList<>();
        if (StringUtils.isBlank(dspInfo.getDspTemplateId()) || StringUtils.isBlank(dspInfo.getDspTagId())) {
            LOGGER.warn("计划未配置dsp相关信息，请检查配置 计划id {}", dspInfo.getIdeaId());
            return null;
        }
        imp.setTagid(dspInfo.getDspTagId());
        templates.add(new Template(dspInfo.getDspTemplateId()));
        imp.setTemplates(templates);
        imp.setId(commonImp.getId());

        // FIXME: 2022/7/11 暂时写死记得删除
//        imp.setTagid("tuia_nat_600*300");
//        imp.setTemplates(Collections.singletonList(new Template("tuia_nat_600*300")));
        long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100)) + 1;
        imp.setBidfloor((int) bidFloor);

        // 2.应用下载类,目前对接拼多多，只有下载类广告
        imp.setContent_type(Arrays.asList(1, 2));
//        imp.setKeyword();
//        imp.setDealid();
        imp.setSupport_deeplink(commonImp.isOpenDeepLink());
//        imp.setH();
//        imp.setW();
//        imp.setBcat();
//        imp.setWcat();
        //这里不需要传ext，因为是要和pdd约定的，众多媒体，约不过来
//        imp.setExt(commonImp.getExt());
        return imp;
    }
}
