/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.MoYiProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter.MoYiRequestConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter.MoYiResponseConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Component
public class MoYiDspInvoker
extends AbstractDspCaller<MoYiBidResponse, MoYiBidRequest> {
    private static final Logger log = LoggerFactory.getLogger(MoYiDspInvoker.class);
    @Resource(name="dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Autowired
    private MoYiRequestConvert moYiRequestConvert;
    @Autowired
    private MoYiResponseConvert moYiResponseConvert;
    @Autowired
    private MoYiProperties moYiProperties;

    @Override
    protected MoYiBidResponse invokeDsp(MoYiBidRequest tanxBiddingRequest) {
        if (tanxBiddingRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u6cab\u6613DSP\u8c03\u7528");
        try {
            return (MoYiBidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.moYiProperties.getUrl(), tanxBiddingRequest), (String)"invokeDSP", (String)"moyi");
        }
        catch (ResourceAccessException e) {
            log.warn("\u6cab\u6613 DSP,http\u8bf7\u6c42\u5f02\u5e38,{}", (Object)e.getMessage());
            throw new DspException(DspErrorCode.DSP_HTTP_INVOKE_FAILED, this.getDsp(), (Exception)((Object)e));
        }
        catch (Exception e) {
            log.error("\u6cab\u6613 DSP\u8bf7\u6c42\u5931\u8d25,{}", (Object)e.getMessage());
            throw new DspException(DspErrorCode.DSP_INVOKE_FAILED, this.getDsp(), e);
        }
        catch (Throwable e) {
            log.error("\u6cab\u6613\u5176\u4ed6\u8c03\u7528\u5f02\u5e38", e);
            return null;
        }
    }

    private MoYiBidResponse doHttpInvoke(String url, MoYiBidRequest request) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, MoYiBidResponse.class, new Object[0]);
        HttpStatus statusCode = resEntity.getStatusCode();
        MoYiBidResponse body = (MoYiBidResponse)resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            }
            SamplerLog.info((String)"\u6cab\u6613DSP\u65e0\u5185\u5bb9\u8fd4\u56de,statusCode:[{}],request[{}],body[{}]", (Object[])new Object[]{statusCode.value(), JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)body)});
            return null;
        }
        if (statusCode.is5xxServerError()) {
            log.warn("\u6cab\u6613DSP\u8fd4\u56de5xx,statusCode:[{}],request[{}],body[{}]", new Object[]{statusCode.value(), JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)body)});
            return null;
        }
        log.warn("\u6cab\u6613DSP\u8fd4\u56de\u5176\u4ed6\u72b6\u6001\u7801,statusCode:[{}],request[{}],body[{}]", new Object[]{statusCode.value(), JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)body)});
        return null;
    }

    private MoYiBidResponse handle2xx(MoYiBidResponse response) {
        if (Objects.isNull(response)) {
            return response;
        }
        if (CollectionUtils.isNotEmpty(response.getSeatBids())) {
            Cat.logMetricForCount((String)"\u6cab\u6613DSP\u8fd4\u56de");
        }
        return response;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        if (Objects.isNull(price)) {
            return null;
        }
        String tme = price.toString();
        try {
            byte[] bytes1 = new byte[16];
            if (tme.length() == 16) {
                bytes1 = tme.getBytes(StandardCharsets.UTF_8);
            }
            if (tme.length() < 16 && tme.length() > 0) {
                byte[] bytes = tme.getBytes(StandardCharsets.UTF_8);
                int length = bytes.length;
                byte[] data2 = new byte[16 - length];
                ByteBuffer buffer = ByteBuffer.allocate(bytes.length + data2.length);
                buffer.put(bytes);
                buffer.put(data2);
                bytes1 = buffer.array();
            }
            SecretKeySpec secretKey = new SecretKeySpec("gnnee3j8tpj65ogu".getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(bytes1);
            return Hex.toHexString((byte[])bytes);
        }
        catch (Exception e) {
            log.warn("\u6cab\u6613\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String tme = "100";
        byte[] bytes1 = new byte[16];
        if (tme.length() == 16) {
            bytes1 = tme.getBytes(StandardCharsets.UTF_8);
        }
        if (tme.length() < 16 && tme.length() > 0) {
            byte[] bytes = tme.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            byte[] data2 = new byte[16 - length];
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + data2.length);
            buffer.put(bytes);
            buffer.put(data2);
            bytes1 = buffer.array();
        }
        SecretKeySpec secretKey = new SecretKeySpec("rrtqgxt8jvanqu5isjcji3giqufegjkx".getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, secretKey);
        byte[] bytes = cipher.doFinal(bytes1);
        System.out.println(Hex.toHexString((byte[])bytes));
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_7.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_7;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("__PRICE__") && price != null) {
            url = url.replaceAll("__PRICE__", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    @Override
    public MoYiBidRequest convertReq(AdxCommonBidRequest request, DspInfo dspInfo) throws DspException {
        try {
            return this.moYiRequestConvert.reqConvert(request, dspInfo);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(MoYiBidResponse response) throws DspException {
        try {
            return this.moYiResponseConvert.respConvert(response);
        }
        catch (Exception e) {
            throw new DspException(DspErrorCode.RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }
}

