package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param;

import lombok.Data;

import java.util.List;

@Data
public class Bid {
    //dsp侧针对这次竞价的ID，手淘生成，与上面的bid_id不一致
    private String id;
    //曝光ID，对应BidRequest.imp.id，必填！
    private String imp_id;
    //DSP出价，cpm：分/千次曝光，cpc：分/单次点击
    //不管是cpm还是cpc都是取price字段作为出价
    private int price;
    //创意ID
    private String creative_id;
    //竞价成功通知地址
    private String nurl;
    //竞价失败通知地址，建议支持回传
    private String lurl;
    //曝光监测地址，cpm结算有价格宏，cpc结算无价格宏
    private List<String> imp_trackers;
    //点击监测地址，cpm结算无价格宏，cpc结算有价格宏
    private List<String> clk_trackers;
    //创意物料信息
    private Adm adm;
    //包名，固定：com.taobao.taobao
    private String package_name;
    //app名称，固定：手机淘宝
    private String app_name;
    //logo url
    private String icon_url;
}
