/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.MeituanProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver.MeituanReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver.MeituanRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.github.luben.zstd.Zstd;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class MeituanDspInvoker
extends AbstractDspCaller<MeituanRTB.RtbResponse, MeituanRTB.RtbRequest> {
    private static final Logger log = LoggerFactory.getLogger(MeituanDspInvoker.class);
    @Autowired
    private MeituanReqConvert reqConvert;
    @Autowired
    private MeituanRespConvert respConvert;
    @Autowired
    private MeituanProperties meituanProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    @Override
    protected MeituanRTB.RtbResponse invokeDsp(MeituanRTB.RtbRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u7f8e\u56e2DSP\u8c03\u7528");
        try {
            return (MeituanRTB.RtbResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.meituanProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"meituan");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u7f8e\u56e2_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u7f8e\u56e2\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private MeituanRTB.RtbResponse doHttpInvoke(String url, MeituanRTB.RtbRequest rtbRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf;charset=UTF-8");
        headers.add("Content- Encoding", "zstd");
        headers.add("Accept-Encoding", "zstd");
        byte[] compressData = Zstd.compress((byte[])rtbRequest.toByteArray());
        HttpEntity entity = new HttpEntity((Object)compressData, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u7f8e\u56e2\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        if (responseEntity.getBody() == null) {
            return null;
        }
        int frameContentSize = (int)Zstd.getFrameContentSize((byte[])((byte[])responseEntity.getBody()));
        byte[] array = new byte[frameContentSize];
        Zstd.decompress((byte[])array, (byte[])((byte[])responseEntity.getBody()));
        try {
            return MeituanRTB.RtbResponse.parseFrom(array);
        }
        catch (InvalidProtocolBufferException e) {
            SamplerLog.warn((String)"\u7f8e\u56e2\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5931\u8d25", (Object[])new Object[]{e});
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(this.meituanProperties.getPriceKey().getBytes(), "AES");
            cipher.init(1, secretKey);
            byte[] encrypted = cipher.doFinal(tme.getBytes());
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            log.warn("\u7f8e\u56e2\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_12.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_12;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("{AUCTION_PRICE}") && price != null) {
            url = url.replace("{AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public MeituanRTB.RtbRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(MeituanRTB.RtbResponse rtbResponse) throws DspException {
        return this.respConvert.convert(rtbResponse);
    }
}

