/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonAppInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonDevice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonGeo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonSizeInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonUserInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.FilterMaterInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.CarrierConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.ConnectionTypeConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.DeviceTypeConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.OsConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.OsvConverter;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import cn.com.duiba.tuia.dsp.engine.api.util.UAUtils;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RgyunRequestConverter {
    private static final Logger log = LoggerFactory.getLogger(RgyunRequestConverter.class);
    @Autowired
    private AppReplace appReplace;
    private static final Integer BANNER_TYPTE = 1;
    private static final Integer VIDEO_TYPE = 3;

    public RgyunBiddingRequest.RTBRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        RgyunBiddingRequest.RTBRequest.Builder builder = RgyunBiddingRequest.RTBRequest.newBuilder();
        RgyunBiddingRequest.RTBRequest.SiteInfo siteInfo = RgyunBiddingRequest.RTBRequest.SiteInfo.newBuilder().setId("800390").setName("\u8f6f\u544a").build();
        builder.setSite(siteInfo);
        builder.setImp(this.convertImp(adxCommonBidRequest, dspInfo));
        builder.setApp(this.convertApp(adxCommonBidRequest.getAppInfo(), dspInfo));
        builder.setDevice(this.convertDevice(adxCommonBidRequest.getDevice(), adxCommonBidRequest.getAdxType()));
        builder.setUser(this.convertUser(adxCommonBidRequest.getUserInfo()));
        builder.setId(adxCommonBidRequest.getRequestId());
        builder.setVersion("2.1.2");
        return builder.build();
    }

    private RgyunBiddingRequest.RTBRequest.UserInfo convertUser(CommonUserInfo userInfo) {
        RgyunBiddingRequest.RTBRequest.UserInfo.Builder userBuilder = RgyunBiddingRequest.RTBRequest.UserInfo.newBuilder();
        if (Objects.isNull(userInfo)) {
            return userBuilder.build();
        }
        userBuilder.setId(this.optionOfNull(userInfo.getId()));
        Optional.ofNullable(userInfo.getYob()).ifPresent(yop -> userBuilder.setAge(String.valueOf(LocalDate.now().getYear() - yop)));
        return userBuilder.build();
    }

    private RgyunBiddingRequest.RTBRequest.DeviceInfo convertDevice(CommonDevice device, Integer adxType) {
        RgyunBiddingRequest.RTBRequest.DeviceInfo.Builder deviceBuilder = RgyunBiddingRequest.RTBRequest.DeviceInfo.newBuilder();
        if (Objects.isNull(device)) {
            return deviceBuilder.build();
        }
        deviceBuilder.setImei(this.optionOfNull(device.getImei()));
        deviceBuilder.setImeimd5(this.optionOfNull(device.getImeiMd5()));
        deviceBuilder.setIdfa(this.optionOfNull(device.getIdFa()));
        deviceBuilder.setIdfamd5(this.optionOfNull(device.getIdFaMd5()));
        deviceBuilder.setIdfv(this.optionOfNull(device.getIdfv()));
        deviceBuilder.setOaid(this.optionOfNull(device.getOaId()));
        deviceBuilder.setOaidmd5(this.optionOfNull(device.getOaIdMd5()));
        deviceBuilder.setUa(this.optionOfNull(device.getUa()));
        deviceBuilder.setIp(this.optionOfNull(device.getIp()));
        UAData uaData = UAUtils.parseUA(device.getUa());
        deviceBuilder.setCarrier(CarrierConverter.getCarrierType(device.getCarrier()));
        deviceBuilder.setMake(this.getMaker(device.getMake(), uaData));
        deviceBuilder.setModel(this.getModel(device.getModel(), uaData));
        RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType osType = OsConverter.getOsType(device.getOs(), uaData);
        deviceBuilder.setOs(osType);
        this.setDeviceId(osType, deviceBuilder, device, adxType);
        deviceBuilder.setOsv(OsvConverter.getOsvType(device.getUa()));
        deviceBuilder.setConnectiontype(ConnectionTypeConverter.getConnectionType(device.getTuiaConnectionType()));
        deviceBuilder.setDevicetype(DeviceTypeConverter.getDeviceType(device.getUa()));
        deviceBuilder.setMac(this.optionOfNull(device.getMac()));
        deviceBuilder.setGeo(this.geoConvert(device.getGeo()));
        return deviceBuilder.build();
    }

    private String getModel(String model, UAData uaData) {
        String model1;
        if (StringUtils.isNotBlank((CharSequence)model)) {
            return model;
        }
        if (Objects.nonNull(uaData) && StringUtils.isNotBlank((CharSequence)(model1 = uaData.getModel()))) {
            return model1;
        }
        return " ";
    }

    private String getMaker(String make, UAData uaData) {
        if (StringUtils.isNotBlank((CharSequence)make)) {
            return make;
        }
        if (Objects.nonNull(uaData)) {
            if (Objects.equals("Android", uaData.getOsType())) {
                return "huawei";
            }
            return "apple";
        }
        return "unknow";
    }

    private void setDeviceId(RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType osType, RgyunBiddingRequest.RTBRequest.DeviceInfo.Builder deviceBuilder, CommonDevice device, Integer adxType) {
        if (!Integer.valueOf(19).equals(adxType)) {
            return;
        }
        switch (osType) {
            case OT_Android: {
                if (!StringUtils.isBlank((CharSequence)deviceBuilder.getOaid())) break;
                deviceBuilder.setOaid(this.optionOfNull(device.getTuiaDeviceId()));
                break;
            }
            case OT_Ios: {
                if (!StringUtils.isBlank((CharSequence)deviceBuilder.getImei()) || !StringUtils.isBlank((CharSequence)deviceBuilder.getIdfa())) break;
                deviceBuilder.setImei(this.optionOfNull(device.getTuiaDeviceId()));
                break;
            }
        }
    }

    private RgyunBiddingRequest.RTBRequest.DeviceInfo.GeoInfo geoConvert(CommonGeo geo) {
        RgyunBiddingRequest.RTBRequest.DeviceInfo.GeoInfo.Builder geoBuilder = RgyunBiddingRequest.RTBRequest.DeviceInfo.GeoInfo.newBuilder();
        if (Objects.isNull(geo)) {
            return geoBuilder.build();
        }
        Optional.ofNullable(geo.getLat()).ifPresent(lat -> geoBuilder.setLat(lat.floatValue()));
        Optional.ofNullable(geo.getLon()).ifPresent(leo -> geoBuilder.setLon(leo.floatValue()));
        return geoBuilder.build();
    }

    private RgyunBiddingRequest.RTBRequest.AppInfo convertApp(CommonAppInfo appInfo, DspInfo dspInfo) {
        RgyunBiddingRequest.RTBRequest.AppInfo.Builder appInfoBuilder = RgyunBiddingRequest.RTBRequest.AppInfo.newBuilder();
        CommonAppInfo replaceApp = this.appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            appInfoBuilder.setName(replaceApp.getName());
            appInfoBuilder.setBundle(replaceApp.getBundle());
        } else {
            if (StringUtils.isNotBlank((CharSequence)appInfo.getName())) {
                appInfoBuilder.setName(appInfo.getName());
            } else {
                appInfoBuilder.setName("\u63a8\u554a");
            }
            if (StringUtils.isNotBlank((CharSequence)appInfo.getBundle())) {
                appInfoBuilder.setBundle(appInfo.getBundle());
            } else {
                appInfoBuilder.setBundle("com.tuia");
            }
            appInfoBuilder.setId(BlowfishUtils.encryptBlowfish((String)(StringUtils.isBlank((CharSequence)appInfo.getId()) ? "YQFDSG" : appInfo.getId())));
        }
        return appInfoBuilder.build();
    }

    private RgyunBiddingRequest.RTBRequest.ImpInfo convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        RgyunBiddingRequest.RTBRequest.ImpInfo.Builder impInfoBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.newBuilder();
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) {
            return impInfoBuilder.build();
        }
        CommonImp commonImp = impList.get(0);
        impInfoBuilder.setId(this.optionOfNull(commonImp.getId()));
        List<CommonSizeInfo> filteringSize = this.filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());
        if (CollectionUtils.isNotEmpty(filteringSize)) {
            CommonSizeInfo commonSizeInfo = filteringSize.get(0);
            ArrayList templateIds = Lists.newArrayList();
            if (dspInfo.getDspTagId() != null) {
                impInfoBuilder.setTagid(dspInfo.getDspTagId());
            }
            if (dspInfo.getDspTemplateId() != null) {
                templateIds.add(dspInfo.getDspTemplateId());
            }
            impInfoBuilder.addAllTemplateIds(templateIds);
            Integer type = commonSizeInfo.getType();
            Integer pos = null;
            if (StringUtils.isNotBlank((CharSequence)dspInfo.getDspResId())) {
                pos = Integer.valueOf(dspInfo.getDspResId());
            }
            if (CollectionUtils.isEmpty((Collection)impInfoBuilder.getTemplateIdsList())) {
                log.warn("\u672a\u627e\u5230\u5bf9\u5e94\u5149\u544a\u5e7f\u544a\u4f4d\uff0ccommonImp", (Object)JSON.toJSONString((Object)commonImp));
                return impInfoBuilder.build();
            }
            if (BANNER_TYPTE.equals(type)) {
                RgyunBiddingRequest.RTBRequest.ImpInfo.BannerInfo.Builder bannerBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.BannerInfo.newBuilder();
                bannerBuilder.setW(commonSizeInfo.getWidth());
                bannerBuilder.setH(commonSizeInfo.getHeight());
                if (pos != null) {
                    bannerBuilder.setPos(RgyunBiddingRequest.RTBRequest.ImpInfo.PosType.forNumber(pos));
                }
                impInfoBuilder.setBanner(bannerBuilder.build());
            } else if (VIDEO_TYPE.equals(type)) {
                RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.Builder videoBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.newBuilder();
                videoBuilder.setW(commonSizeInfo.getWidth());
                videoBuilder.setH(commonSizeInfo.getHeight());
                if (pos != null) {
                    videoBuilder.setPos(RgyunBiddingRequest.RTBRequest.ImpInfo.PosType.forNumber(pos));
                }
                videoBuilder.setMinduration(Optional.ofNullable(commonSizeInfo.getMinduration()).orElse(5));
                videoBuilder.setMaxduration(Optional.ofNullable(commonSizeInfo.getMaxduration()).orElse(30));
                RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.VideoCover.Builder coverBuilder = RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.VideoCover.newBuilder();
                coverBuilder.setCovertype(RgyunBiddingRequest.RTBRequest.ImpInfo.VideoInfo.VideoCover.CoverType.IMAGE);
                videoBuilder.setCover(coverBuilder.build());
                impInfoBuilder.setVideo(videoBuilder.build());
            } else {
                log.warn("\u8f6f\u544adsp convertImp \u65e0\u6cd5\u8bc6\u522b\u662fbanner \u8fd8\u662f video");
                return impInfoBuilder.build();
            }
        }
        impInfoBuilder.setId(commonImp.getId());
        long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100.0)) + 1L;
        impInfoBuilder.setBidfloor(bidFloor);
        return impInfoBuilder.build();
    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        ArrayList commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = this.matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (!Objects.nonNull(commonSizeInfo1)) continue;
            commonSizeInfos.add(commonSizeInfo1);
        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (!filterMaterInfo.getWidth().equals(width) || !filterMaterInfo.getHeight().equals(height)) continue;
            return commonSizeInfo;
        }
        return null;
    }

    private String optionOfNull(String param) {
        return Optional.ofNullable(param).orElse("");
    }
}

