/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.config.DspApolloConfig;
import cn.com.duiba.tuia.dsp.engine.api.dsp.DspAdapter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.CommonImp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.log.DspRequestLog;
import cn.com.duiba.tuia.dsp.engine.api.log.DspReturnLog;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractDspCaller<DspRsp, DspReq>
implements DspAdapter<DspRsp, DspReq> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDspCaller.class);
    public static final String JSTR = "{\"commonSeatBidList\":[{\"advertiserId\":\"pinduoduo\",\"clickCallbackUrl\":\"https://t-dsp.pinduoduo.com/dspcb/c/mrk_union?acc=100001&mt_id=101377678012&vers=A2c-L-V-Finner-S6a&source=0&lx=1&creative_id=101377678012&super_channel=mrk_union_tuia&cate3_id=5836&ut=3&audience=0&idfa=8f802bd2c3cc50a2473fb23de4b9027e&goods_id=278945178607&cate_id=5836&ads_set=10004290&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&soid=e9154a0aafc70d636002000060c9e00080bccf1d&display_id=1325&ad_tag=1%3A5834%3A2&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&y2=9268&pcvr=6.0E-5&y4=9055&pkg_id=5378973&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&y9=8331&os=ios&launch_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&lxt=98&mat_c=6&didc=8f802bd2c3cc50a2473fb23de4b9027e&st0=-1&ltv=113.34192657470703&st16=0&ct=0&app_name=&st1=34&st12=1&st5=6.0E-5&st8=0&y20=400000&bucket_dsp=45&st7=-1&st11=0&st9=1&cate2_id=5835&hg_env=qcloud&did=8f802bd2c3cc50a2473fb23de4b9027e\",\"commonContext\":{\"deepLinkUrl\":\"pddopen://pinduoduo?h5Url=mtr_portals.html%3F_p_acc%3D100001%26_p_source%3D0%26_p_cate1_id%3D5834%26_p_ads_id%3D-1%26_p_jump_id%3D1770%26_p_vids%3D8513%2C9345%2C9282%2C8774%2C400000%2C8331%2C9292%2C8665%2C6000002%2C8668%2C9055%2C8546%2C8933%2C8998%2C7079%2C8871%2C6058%2C9258%2C8751%2C8818%2C8178%2C9266%2C8051%2C9268%2C8893%2C9278%26_p_ads_sub_channel%3Dmrk_union_tuia%26y2%3D9268%26sn%3Dnt_ce740e10%26_p_ads_channel%3Dmrk_union%26y4%3D9055%26_p_ads_csite%3Dtuia_aff_splsh%26m_id%3D81709f%26y9%3D8331%26_p_ads_type%3Dlaxin%26_p_ads_set%3D10004290%26_p_launch_id%3De9154a0aafc70d636002000060c9e00080bccf1d_0%26_p_super_channel%3Dmrk_union_tuia%26_p_bucket_dsp%3D45%26goods_id%3D278945178607%26_p_launch_type%3Ddsp%26_p_mat_pkg_id%3D5378973%26_p_creative_id%3D101377678012%26st16%3D0%26_p_pdd_bid_id%3De9154a0aafc70d636002000060c9e00080bccf1d_0%26st12%3D1%26_p_display_id%3D1325%26st8%3D0%26y20%3D400000%26_oc_ads_channel%3Dmrk_union%26st11%3D0%26_p_mt_id%3D101377678012%26_p_soid%3De9154a0aafc70d636002000060c9e00080bccf1d%26_p_plgsn%3D1b0414324f958f6191c3390e2022755f%26_p_is_reten%3D0%26_p_vers%3DA2c-L-V-Finner-S6a&direct_back=true\"},\"commonCreative\":{\"appBundle\":\"1044283059\",\"appName\":\"\u62fc\u591a\u591a\",\"appVersion\":\"6.25.0\",\"commonDesc\":{},\"commonImageList\":[{\"height\":1280,\"url\":\"http://images.pinduoduo.com/marketing_api/2022-08-20/8d8509d3-1e45-46f4-aa46-e8c95c363767.png?imageMogr2/thumbnail/360x644!\",\"width\":720}],\"commonTitle\":{\"title\":\"\u82f9\u679c\u624b\u673a\u964d\u4ef7\u5566\uff01\"},\"developer\":\"\u4e0a\u6d77\u5bfb\u68a6\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8\",\"downloadUrl\":\"https://api.pinduoduo.com/api/app/channel/pinduoduo_main_mrk_union_max\",\"landingPageUrl\":\"https://lp.pinduoduo.com/poros/h5?vst_scene=pdv&acc=100001&mt_id=101377678012&ads_type=laxin&vers=A2c-L-V-Finner-S6a&_dr_m_id=81709f&source=0&lx=1&creative_id=101377678012&super_channel=mrk_union_tuia&page_uid=b5af197d12ad4d18b4b467684f90f17b&ut=3&audience=0&abs_id=152848&goods_id=278945178607&_da_is_reten=0&ads_set=10004290&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&soid=e9154a0aafc70d636002000060c9e00080bccf1d&ads_channel=mrk_union&display_id=1325&ad_tag=1%3A5834%3A2&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&y2=9268&y4=9055&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&y9=8331&plsn=4cdcaffa7fe6deb33f6ad2f99a706b0b&os=ios&src=mrk_union&lxt=98&mat_c=6&st0=-1&ltv=113.34192657470703&st2=gzyDSg%2FQeq0W81JhVb7yu4ohESI4ltUIpvFwEJPUq2ofXXdaWEGdUQ%3D%3D&st16=0&app_name=&st1=34&mat_pkg_id=5378973&st12=1&st13=97mikHGlbUEfXXdaWEGdUQ%3D%3D&st8=0&y20=400000&bucket_dsp=45&st7=-1&st11=0&st9=1\",\"permissionLink\":\"https://lp.pinduoduo.com/poros/h5?vst_scene=pdv&plsn=c62e1fb641c2b1accab9f99123f47d08&ads_channel=mrk_union&abs_id=140902&page_uid=86ec47c2c03a4b3499d62161c41ff01b\",\"privacyPolicyLink\":\"https://mobile.yangkeduo.com/private_policy.html\"},\"exposureCallbackUrl\":\"https://t-dsp.pinduoduo.com/dspcb/i/mrk_union?acc=100001&mt_id=101377678012&vers=A2c-L-V-Finner-S6a&source=0&lx=1&creative_id=101377678012&price=%%PRICE%%&super_channel=mrk_union_tuia&cate3_id=5836&ut=3&audience=0&goods_id=278945178607&cate_id=5836&ads_set=10004290&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0&soid=e9154a0aafc70d636002000060c9e00080bccf1d&display_id=1325&ad_tag=1%3A5834%3A2&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&y2=9268&y4=9055&pkg_id=5378973&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&y9=8331&os=ios&lxt=98&mat_c=6&didc=8f802bd2c3cc50a2473fb23de4b9027e&st0=-1&st2=8f802bd2c3cc50a2473fb23de4b9027e&st16=0&ct=0&app_name=&st1=34&st4=0.05025&st6=155&st12=1&st5=6.0E-5&st8=0&st10=1.03401&y20=400000&bucket_dsp=45&st7=-1&st11=0&st9=1&cate2_id=5835&hg_env=qcloud&did=8f802bd2c3cc50a2473fb23de4b9027e\",\"price\":155.0,\"winCallbackUrl\":\"https://t-dsp.pinduoduo.com/dspcb/w/mrk_union?acc=100001&soid=e9154a0aafc70d636002000060c9e00080bccf1d&display_id=1325&mt_id=101377678012&vers=A2c-L-V-Finner-S6a&ad_tag=1%3A5834%3A2&source=0&lx=1&creative_id=101377678012&ads_csite=tuia_aff_splsh&price_st=0&cate1_id=5834&price=%%PRICE%%&super_channel=mrk_union_tuia&y2=9268&y4=9055&make=apple&bundle=&ads_sub_channel=mrk_union_tuia&ut=3&y9=8331&audience=0&os=ios&goods_id=278945178607&lxt=98&didc=8f802bd2c3cc50a2473fb23de4b9027e&st0=-1&st16=0&ads_set=10004290&app_name=&st1=34&st12=1&vids=8513,9345,9282,8774,400000,8331,9292,8665,6000002,8668,9055,8546,8933,8998,7079,8871,6058,9258,8751,8818,8178,9266,8051,9268,8893,9278&ads_id=-1&st8=0&y20=400000&st7=-1&st11=0&did=8f802bd2c3cc50a2473fb23de4b9027e&pdd_bid_id=e9154a0aafc70d636002000060c9e00080bccf1d_0\"}],\"dspId\":3,\"requestId\":\"9791855853c04fbf\"}";
    @Resource
    DspApolloConfig dspApolloConfig;
    @Resource
    private CloseableHttpClientUtil httpClientUtil;
    @Autowired
    private ApolloPanGuService apolloPanGuService;
    @Autowired
    private ExecutorService executorService;
    private static final Random random = new Random();

    @Override
    public AdxCommonBidResponse doBid(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo) {
        int index = random.nextInt(100);
        this.executorService.execute(() -> {
            try {
                CommonImp commonImp;
                if (index != 0) {
                    return;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("adxRid", (Object)commonBidRequest.getAdxRid());
                jsonObject.put("groupId", (Object)dspInfo.getGroupId());
                jsonObject.put("resourceId", (Object)dspInfo.getResourceId());
                jsonObject.put("ideaId", (Object)dspInfo.getIdeaId());
                jsonObject.put("mediaChargeType", (Object)commonBidRequest.getMediaChargeType());
                if (Objects.nonNull(commonBidRequest.getDevice())) {
                    jsonObject.put("ip", (Object)commonBidRequest.getDevice().getIp());
                    jsonObject.put("deviceId", (Object)commonBidRequest.getDevice().getTuiaDeviceId());
                    jsonObject.put("deviceIdType", (Object)commonBidRequest.getDevice().getDeviceIdType());
                }
                if (CollectionUtils.isNotEmpty(commonBidRequest.getImpList()) && Objects.nonNull(commonImp = commonBidRequest.getImpList().get(0))) {
                    jsonObject.put("externalAdBlockId", (Object)commonImp.getExternalAdBlockId());
                    jsonObject.put("floorPrice", (Object)commonImp.getFloorPrice());
                }
                if (Objects.nonNull(commonBidRequest.getAppInfo())) {
                    jsonObject.put("packageName", (Object)commonBidRequest.getAppInfo().getBundle());
                    jsonObject.put("baiduAppId", (Object)commonBidRequest.getAppInfo().getId());
                }
                DspRequestLog.log(JSON.toJSONString((Object)jsonObject));
            }
            catch (Exception e) {
                log.warn("\u6253\u5370dsp\u8bf7\u6c42\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            }
        });
        Integer adxCode = commonBidRequest.getAdxType();
        try {
            Object dspReq = this.convertReq(commonBidRequest, dspInfo);
            if (dspReq instanceof Message) {
                this.catLogAndSampleLog(commonBidRequest, "dspReq", JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)((GeneratedMessageV3)dspReq)));
            } else {
                this.catLogAndSampleLog(commonBidRequest, "dspReq", dspReq);
            }
            DspRsp dspRsp = this.invokeDsp(dspReq);
            AdxCommonBidResponse adxCommonBidResponse = this.convertResp(dspRsp);
            if (adxCommonBidResponse == null) {
                return null;
            }
            adxCommonBidResponse.setRequestId(commonBidRequest.getRequestId());
            adxCommonBidResponse.setIdeaId(dspInfo.getIdeaId());
            if (dspRsp instanceof Message) {
                this.catLogAndSampleLog(commonBidRequest, "dspRsp", JsonFormat.printer().print((MessageOrBuilder)((GeneratedMessageV3)dspRsp)));
            } else {
                this.catLogAndSampleLog(commonBidRequest, "dspRsp", dspRsp);
            }
            if (index == 0) {
                this.dspReturnLog(commonBidRequest, dspInfo, adxCommonBidResponse);
            }
            return adxCommonBidResponse;
        }
        catch (Exception e) {
            log.warn("DSP\u7ade\u4ef7\u5931\u8d25 commonBidRequest is {} ", (Object)commonBidRequest, (Object)e);
            Cat.logMetricForCount((String)(this.getDsp().getDesc() + "_\u7ade\u4ef7\u5931\u8d25"));
            return null;
        }
    }

    private void dspReturnLog(AdxCommonBidRequest commonBidRequest, DspInfo dspInfo, AdxCommonBidResponse adxCommonBidResponse) {
        CommonImp commonImp;
        JSONObject log = new JSONObject();
        log.put("adxRid", (Object)commonBidRequest.getAdxRid());
        log.put("groupId", (Object)dspInfo.getGroupId());
        log.put("resourceId", (Object)dspInfo.getResourceId());
        log.put("ideaId", (Object)dspInfo.getIdeaId());
        log.put("userScore", (Object)adxCommonBidResponse.getUserScoreLevel());
        log.put("mediaChargeType", (Object)commonBidRequest.getMediaChargeType());
        if (Objects.nonNull(commonBidRequest.getDevice())) {
            log.put("ip", (Object)commonBidRequest.getDevice().getIp());
            log.put("deviceId", (Object)commonBidRequest.getDevice().getTuiaDeviceId());
            log.put("deviceIdType", (Object)commonBidRequest.getDevice().getDeviceIdType());
        }
        if (CollectionUtils.isNotEmpty(commonBidRequest.getImpList()) && Objects.nonNull(commonImp = commonBidRequest.getImpList().get(0))) {
            log.put("externalAdBlockId", (Object)commonImp.getExternalAdBlockId());
            log.put("floorPrice", (Object)commonImp.getFloorPrice());
        }
        if (Objects.nonNull(commonBidRequest.getAppInfo())) {
            log.put("packageName", (Object)commonBidRequest.getAppInfo().getBundle());
            log.put("baiduAppId", (Object)commonBidRequest.getAppInfo().getId());
        }
        List<CommonSeatBid> commonSeatBidList = adxCommonBidResponse.getCommonSeatBidList();
        CommonSeatBid commonSeatBid = commonSeatBidList.get(0);
        log.put("price", (Object)commonSeatBid.getPrice());
        String dspTaskId = null;
        if (commonSeatBid.getCommonContext().getDeepLinkUrl() != null) {
            String deepLinkUrl = commonSeatBid.getCommonContext().getDeepLinkUrl();
            dspTaskId = this.getDspTaskId(deepLinkUrl);
        }
        if (dspTaskId == null && commonSeatBid.getCommonContext().getULinkUrl() != null) {
            dspTaskId = this.getDspTaskId(commonSeatBid.getCommonContext().getULinkUrl());
        }
        if (dspTaskId != null) {
            log.put("dspTaskId", (Object)dspTaskId);
            adxCommonBidResponse.setDspTaskId(dspTaskId);
        }
        DspReturnLog.log(JSON.toJSONString((Object)log));
    }

    private String getDspTaskId(String deepLinkUrl) {
        try {
            deepLinkUrl = URLDecoder.decode(deepLinkUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (deepLinkUrl.contains("bc_fl_src")) {
            String[] params;
            for (String param : params = deepLinkUrl.split("&")) {
                String[] keyValue;
                if (!param.startsWith("bc_fl_src") || (keyValue = param.split("=")).length != 2) continue;
                return keyValue[1].split("-")[2];
            }
        }
        return null;
    }

    public void catLogAndSampleLog(AdxCommonBidRequest request, String logBody, Object object) {
        String adxCode = request.getAdxCode();
        Integer adxType = request.getAdxType();
        Cat.logMetricForCount((String)(adxCode + "_" + logBody));
        if (SamplerLog.infoFlag()) {
            if (object instanceof String) {
                SamplerLog.info((String)(logBody + " adxCode is {} dsp is {} body is {}"), (Object[])new Object[]{adxCode, this.getDsp().getDesc(), object});
            } else {
                SamplerLog.info((String)(logBody + " adxCode is {} dsp is {} body is {}"), (Object[])new Object[]{adxCode, this.getDsp().getDesc(), JSONObject.toJSONString((Object)object)});
            }
        }
    }

    protected abstract DspRsp invokeDsp(DspReq var1);

    public abstract String priceEncryption(BigDecimal var1);

    protected abstract Integer getDspId();

    protected abstract DspEnum getDsp();

    protected abstract String replaceUrl(String var1, String var2);

    public void doWinCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    public void doClickCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }

    public void doExposureCallBack(String url) {
        this.httpClientUtil.doGet(url);
    }
}

