/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.meituan;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.MeituanProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver.MeituanReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.conver.MeituanRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.meituan.param.MeituanRTB;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.github.luben.zstd.Zstd;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class MeituanDspInvoker
extends AbstractDspCaller<MeituanRTB.RtbResponse, MeituanRTB.RtbRequest> {
    private static final Logger log = LoggerFactory.getLogger(MeituanDspInvoker.class);
    @Autowired
    private MeituanReqConvert reqConvert;
    @Autowired
    private MeituanRespConvert respConvert;
    @Autowired
    private MeituanProperties meituanProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    @Override
    protected MeituanRTB.RtbResponse invokeDsp(MeituanRTB.RtbRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u7f8e\u56e2DSP\u8c03\u7528");
        try {
            return (MeituanRTB.RtbResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.meituanProperties.getUrl(), rtbRequest), (String)"invokeDSP", (String)"meituan");
        }
        catch (Throwable t) {
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                log.warn("\u7f8e\u56e2\u8c03\u7528\u5f02\u5e38", t);
                Cat.logMetricForCount((String)"\u7f8e\u56e2_\u7ade\u4ef7\u5931\u8d25");
            }
            return null;
        }
    }

    private MeituanRTB.RtbResponse doHttpInvoke(String url, MeituanRTB.RtbRequest rtbRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf;charset=UTF-8");
        headers.add("Content-Encoding", "zstd");
        headers.add("Accept-Encoding", "zstd");
        byte[] compressData = Zstd.compress((byte[])rtbRequest.toByteArray());
        HttpEntity entity = new HttpEntity((Object)compressData, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof ResourceAccessException)) {
                SamplerLog.warn((String)"\u7f8e\u56e2\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (HttpStatus.NO_CONTENT.equals((Object)statusCode)) {
            return null;
        }
        byte[] body = (byte[])responseEntity.getBody();
        if (body == null) {
            return null;
        }
        int frameContentSize = (int)Zstd.getFrameContentSize((byte[])body);
        if (frameContentSize < 0) {
            SamplerLog.info((String)"\u7f8e\u56e2 response {}", (Object[])new Object[]{responseEntity});
            return null;
        }
        byte[] array = new byte[frameContentSize];
        Zstd.decompress((byte[])array, (byte[])body);
        try {
            MeituanRTB.RtbResponse rtbResponse = MeituanRTB.RtbResponse.parseFrom(array);
            if (CollectionUtils.isNotEmpty(rtbResponse.getBidsList())) {
                Cat.logMetricForCount((String)"\u7f8e\u56e2DSP\u8fd4\u56de");
                return rtbResponse;
            }
        }
        catch (InvalidProtocolBufferException e) {
            SamplerLog.warn((String)"\u7f8e\u56e2\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5931\u8d25", (Object[])new Object[]{e});
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String tme = price.toString();
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(this.meituanProperties.getPriceKey().getBytes(), "AES");
            cipher.init(1, secretKey);
            byte[] encrypted = cipher.doFinal(tme.getBytes());
            String encode = Base64.getEncoder().encodeToString(encrypted);
            return URLEncoder.encode(encode, "UTF-8");
        }
        catch (Exception e) {
            log.warn("\u7f8e\u56e2\u52a0\u5bc6\u5931\u8d25 ", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String url = "https://impdsp.meituan.com/show?dcp=vjgznAyzsSVxR9gRDsLs0DV8cTooAAQ0R-EjUn3w47qaSQnnzss5OIFHGNZdjy3FqMLY2GEOJS0gYTHG0nzvzRlL3vktq_AqfCuHmat2w_vkLwSKUdR8pciz1BH_xhQsKp5ebsdlA2qH3S-hZxzotXv_JMFfXZlskFcaUzWxKXnvZDW7PXv4jibusUXOAeCwmvU_bO5NoRiCl_KLlomxIzrVT2KIavNX8pxEE3vkt3PXUhi5BwXwuKCn0g9UXsjnzKuW_8CprCmIufL94_Nf3DpXQBpLPm_aZJaAOFqFnkaoN4THVRYvYGz13W08sEvb65ElzaWCCuBYW_LRrvOsd13VpV1veikEAygmmXNtaBJJZZ9Ry1WQfdhvWIlEgqJe_PdQM2j2XW6Rzuh26KLQXXJmw4qIRD-bnwJqSYbtK0qUCkVQrdc43gIliojz4NsYLTwyXfTdWIOfsyhpiZpJ&driverid=349a3b9eac6e15d016738d3d3b675640&p={AUCTION_PRICE}";
        MeituanDspInvoker meituanDspInvoker = new MeituanDspInvoker();
        String s1 = meituanDspInvoker.replaceUrl("I6TO%2FHvxU%2BfUn36ILuObvQ%3D%3D", url);
        System.out.println(s1);
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_12.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_12;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("{AUCTION_PRICE}") && price != null) {
            url = url.replace("{AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public MeituanRTB.RtbRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(MeituanRTB.RtbResponse rtbResponse) throws DspException {
        return this.respConvert.convert(rtbResponse);
    }
}

