package cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.qihang.param.QiHangBidding;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class QiHangRespConvert {

    public AdxCommonBidResponse convert(QiHangBidding.BidResponse bidResponse) {
        if (bidResponse == null) {
            return null;
        }
        List<QiHangBidding.BidResponse.SeatBid> seatBidList = bidResponse.getSeatBidList();
        if (CollectionUtils.isEmpty(seatBidList)) {
            return null;
        }
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(DspEnum.DSP_10.getDspId());
        QiHangBidding.BidResponse.SeatBid seatBid = seatBidList.get(0);
        QiHangBidding.BidResponse.Bid bid = seatBid.getBid(0);
        CommonSeatBid commonSeatBid = bidConvert(bid);
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        return response;
    }

    private CommonSeatBid bidConvert(QiHangBidding.BidResponse.Bid bid) {
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBid.setPrice((double) bid.getPrice());
        String nurl = bid.getNurl();
        commonSeatBid.setWinCallbackUrls(Collections.singletonList(nurl));
        ArrayList<String> exposureUrls = new ArrayList<>(bid.getClkTrackersList());
        commonSeatBid.setExposureCallbackUrls(exposureUrls);
        ArrayList<String> clkUrls = new ArrayList<>(bid.getClkTrackersList());
        commonSeatBid.setClickCallbackUrls(clkUrls);
        CommonCreative commonCreative = new CommonCreative();
        commonCreative.setAppName(bid.getAppName());
        commonCreative.setAppBundle(bid.getPackageName());
        commonCreative.setIconUrl(bid.getIconUrl());
        CommonIcon commonIcon = new CommonIcon();
        commonIcon.setUrl(bid.getIconUrl());
        commonCreative.setCommonIcon(commonIcon);
        QiHangBidding.BidResponse.Bid.Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank(adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        //根据是否有视频判断素材类型 非视频就是图片
        if (adm.hasVideo()) {
            QiHangBidding.BidResponse.Bid.Adm.Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getVideoUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(adm.getCoverImgUrl());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            List<QiHangBidding.BidResponse.Bid.Adm.Image> imageList = adm.getImageList();
            List<CommonImage> commonImages = new ArrayList<>(imageList.size());
            for (QiHangBidding.BidResponse.Bid.Adm.Image image : imageList) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image.getUrl());
                commonImage.setWidth(image.getWidth());
                commonImage.setHeight(image.getHeight());
                commonImages.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImages);
        }
        if (StringUtils.isNotBlank(adm.getDeepLink())) {
            commonCreative.setDeepLinkUrl(adm.getDeepLink());
        }
        if (StringUtils.isNotBlank(adm.getUniversalLink())) {
            commonCreative.setULinkUrl(adm.getUniversalLink());
        }
        commonCreative.setLandingPageUrl(adm.getLandingSite());
        commonSeatBid.setCommonCreative(commonCreative);
        return commonSeatBid;
    }
}
