package cn.com.duiba.tuia.dsp.engine.api.dsp.buluken.bean;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by hong
 * time 2023/8/21.
 */
@Data
public class BuLuKenBidRequest {
    private String id;
    private String version;
    private List<Imp> imp;
    private App app;
    private Site site;
    private Device device;
    private User user;
    private List<Content> content;

    // imp, app, device是必填字段
    // app和site二选一
    @Data
    // 对应的内部对象
    public static class Imp {
        private String id;
        private String tagid;
        private Double bidfloor;
        private Banner banner;
        @JSONField(name ="native")
        @JsonProperty("native")
        private Native nativeObj;
        private Video video;
        private Boolean isdownload;
        private Boolean isdeeplink;
        private Boolean isul;
        private Integer secure;
        private Pmp pmp;

        // banner, native, video 必须三选一
    }
    @Data
    public static class Banner {
        private Integer w;
        private Integer h;
        private Integer pos;
    }
    @Data
    public static class Native {
        private List<Asset> assets;
        private Integer layout;
        @lombok.Data
        public static class Asset {
            private Integer id;
            private Integer isrequired;
            private Title title;
            private Img img;
            private Video video;
            private Data data;
        }
        @lombok.Data
        public static class Title {
            private Integer len;
        }
        @lombok.Data
        public static class Img {
            private Integer type;
            private Integer wmin;
            private Integer hmin;
            private List<String> mimes;
        }
        @lombok.Data
        public static class Video {
            private Integer wmin;
            private Integer hmin;
            private List<String> mimes;
        }
        @lombok.Data
        public static class Data {
            private Integer type;
            private Integer len;
        }

    }
    @Data
    public static class Video {
        private Integer w;
        private Integer h;
        private Integer type;
        private Integer minduration;
        private Integer maxduration;
        private Integer startdelay;
        private List<String> mimes;
        private Integer orientation;
        private Integer delivery;
        private Integer linearity;
        private Integer minbitrate;
        private Integer maxbitrate;
    }
    @Data
    public static class Pmp {
        private List<Deal> deals;
    }
    @Data
    public static class Deal {
        private String id;
        private Double bidfloor;
    }
    @Data
    public static class App {
        private String bundle;
        private String name;
        private String version;
        private String appstoreversion;
        private List<String> cat;
        private List<String> keywords;
        private List<String> pagecat;
    }
    @Data
    public static class Site {
        private String domain;
        private String name;
        private String page;
        private String ref;
        private String keywords;
        private List<String> pagecat;
        private String search;
    }
    @Data
    public static class Device {
        private String os;
        private String osv;
        private String did;
        private String didmd5;
        private String oid;
        private String oidmd5;
        private String ifa;
        private String ifamd5;
        private String androidid;
        private String androididmd5;
        private String ip;
        private String ipv6;
        private String ua;
        private Integer connectiontype;
        private Integer devicetype;
        private String make;
        private String model;
        private String carrier;
        private Geo geo;
    }
    @Data
    public static class Geo {
        private Double lat;
        private Double lon;
        private Integer coordinate;
        private Long timestamp;
        private Double accu;
    }
    @Data
    public static class User {
        private String id;
        private String gender;
        private Integer yob;
        private String keywords;
        private List<Segment> segments;
    }
    @Data
    public static class Segment {
        private String id;
        private String name;
        private List<Value> values;
    }
    @Data
    public static class Value {
        private String id;
        private String name;
        private Double weight;
    }
    @Data
    public static class Content {
        private String title;
        private List<String> cat;
        private String keywords;
        private Integer context;
    }
}
