package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by hong
 * time 2023/8/21.
 */
@Data
public class MoYiBidRequest {
    @JSONField(name = "request_id")
    @JsonProperty("request_id")
    private String requestId;

    private List<Imp> imp;

    private Device device;

    private App app;

    private User user;
    @JSONField(name ="gx_caid")
    @JsonProperty("gx_caid")
    private GxCaid gxCaid;
    private Geo geo;

    @JSONField(name ="at")
    @JsonProperty("at")
    private Integer auctionType;
    @Data
    public static class Imp {

        private String id;

        private String tagid;

        @JSONField(name ="bid_floor")
        @JsonProperty("bid_floor")
        private Integer bidFloor;

        @JSONField(name ="ad_types")
        @JsonProperty("ad_types")
        private List<Integer> adTypes;

        private Integer w;

        private Integer h;


    }
    @Data
    public static class Device {

        private String ua;

        @JSONField(name ="webview_ua")
        @JsonProperty("webview_ua")
        private String webViewUa;

        private String ip;

        private String ipv6;

        private Geo geo;

        @JSONField(name ="make")
        @JsonProperty("make")
        private String make;

        private String brand;

        @JSONField(name ="device_type")
        @JsonProperty("device_type")
        private Integer deviceType;

        private String model;

        private Integer width;

        private Integer height;

        private String os;

        private String osv;

        private Integer ppi;

        private Integer dpi;

        @JSONField(name ="connection_type")
        @JsonProperty("connection_type")
        private Integer connectionType;

        private Integer carrier;

        @JSONField(name ="android_id")
        @JsonProperty("android_id")
        private String androidId;

        @JSONField(name ="android_id_md5")
        @JsonProperty("android_id_md5")
        private String androidIdMd5;

        private String idfa;

        @JSONField(name ="idfa_md5")
        @JsonProperty("idfa_md5")
        private String idfaMd5;

        @JSONField(name ="oaid")
        @JsonProperty("oaid")
        private String oaid;

        @JSONField(name ="oaid_md5")
        @JsonProperty("oaid_md5")
        private String oaidMd5;

        private String imei;

        @JSONField(name ="imei_md5")
        @JsonProperty("imei_md5")
        private String imeiMd5;

        private String mac;

        @JSONField(name ="mac_md5")
        @JsonProperty("mac_md5")
        private String macMd5;

        @JSONField(name ="boot_mark")
        @JsonProperty("boot_mark")
        private String bootMark;

        @JSONField(name ="update_mark")
        @JsonProperty("update_mark")
        private String updateMark;

        @JSONField(name ="startup_time")
        @JsonProperty("startup_time")
        private String startupTime;

        @JSONField(name ="mb_time")
        @JsonProperty("mb_time")
        private String mbTime;

        @JSONField(name ="wifi_ssid")
        @JsonProperty("wifi_ssid")
        private String wifiSsid;

        @JSONField(name ="wifi_mac")
        @JsonProperty("wifi_mac")
        private String wifiMac;

        @JSONField(name ="mem_total")
        @JsonProperty("mem_total")
        private Integer memTotal;

        @JSONField(name ="disk_total")
        @JsonProperty("disk_total")
        private Integer diskTotal;

        @JSONField(name ="model_type")
        @JsonProperty("model_type")
        private String modelType;

        @JSONField(name ="country_code")
        @JsonProperty("country_code")
        private String countryCode;

        private String language;

        @JSONField(name ="phone_name")
        @JsonProperty("phone_name")
        private String phoneName;

        @JSONField(name ="hwmachine")
        @JsonProperty("hwmachine")
        private String hwMachine;

        @JSONField(name ="local_tz_time")
        @JsonProperty("local_tz_time")
        private String localTzTime;


    }
    @Data
    public static class User {

        private String gender;

        private Integer yob;

        private Integer age;


    }
    @Data
    public static class Geo {

        private float lat;

        private float lon;

        private String city;


    }
    @Data
    public static class GxCaid {

        private String id;

        @JSONField(name ="id_md5")
        @JsonProperty("id_md5")
        private String idMd5;

        @JSONField(name ="generate_time")
        @JsonProperty("generate_time")
        private Integer generateTime;

        private Integer version;

        private Integer vendor;


    }
    @Data
    public static class App {

        private String name;

        @JSONField(name ="package_name")
        @JsonProperty("package_name")
        private String packageName;

        @JSONField(name ="installed_client_apps")
        @JsonProperty("installed_client_apps")
        private List<String> installedClientApps;

        private String ver;


    }
}
