package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean.MoYiBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.ConnectionTypeConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter.OsConvert;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Component
@Slf4j
public class MoYiRequestConvert {
    @Autowired
    private AppReplace appReplace;

    public MoYiBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MoYiBidRequest builder = new MoYiBidRequest();
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setAuctionType(2);
        convertImp(builder, adxCommonBidRequest, dspInfo);
        convertApp(builder, adxCommonBidRequest, dspInfo);
        convertDevice(builder, adxCommonBidRequest);
        return builder;
    }

    public void convertImp(MoYiBidRequest builder, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {

        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);

        MoYiBidRequest.Imp imp = new MoYiBidRequest.Imp();

        List<CommonSizeInfo> filteringSize = filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());

        if (CollectionUtils.isNotEmpty(filteringSize)) {
            CommonSizeInfo commonSizeInfo = filteringSize.get(0);

            if (dspInfo.getDspTagId() != null) {
                imp.setTagid(dspInfo.getDspTagId());
            }
        }


        imp.setId(commonImp.getId());
        imp.setBidFloor((int) Math.round(commonImp.getFloorPrice()) + 1);

        imp.setAdTypes(commonImp.getContentTypes());

        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        imp.setW(commonSizeInfo.getWidth());
        imp.setH(commonSizeInfo.getHeight());
        builder.setImp(Collections.singletonList(imp));
    }

    public final String ANDROID = "0";
    public final String IOS = "1";

    public String getOsType(String os) {
        if (StringUtils.isBlank(os)) {
            return "unknown";
        }
        switch (os) {
            case ANDROID:
                return "Android";
            case IOS:
                return "iOS";
            default:
                return "unknown";
        }
    }

    //移动
    public static final String MOVE = "1";
    //联通
    public static final String UNICOM = "2";
    //电信
    public static final String TELECOM = "3";

    public Integer getCarrierType(String carrier) {
        if (StringUtils.isBlank(carrier)) {
            return 0;
        }
        switch (carrier) {
            case MOVE:
                return 1;
            case UNICOM:
                return 2;
            case TELECOM:
                return 3;
            default:
                return 0;
        }
    }


    public void convertDevice(MoYiBidRequest request, AdxCommonBidRequest adxCommonBidRequest) {
        MoYiBidRequest.Device builder = new MoYiBidRequest.Device();
        CommonDevice device = adxCommonBidRequest.getDevice();
        builder.setIp(device.getIp());
        builder.setUa(device.getUa());
        builder.setWebViewUa(device.getUa());
        if (StringUtils.isNotEmpty(device.getImeiMd5())) {
            builder.setImeiMd5(StringUtils.upperCase(device.getImeiMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaIdMd5())) {
            builder.setOaidMd5(StringUtils.upperCase(device.getOaIdMd5()));
        }
        if (StringUtils.isNotEmpty(device.getIdFaMd5())) {
            builder.setIdfaMd5(StringUtils.upperCase(device.getIdFaMd5()));
        }
        if (StringUtils.isNotEmpty(device.getOaId())) {
            builder.setOaid(device.getOaId());
        }
        builder.setDeviceType(1);
        builder.setBrand(device.getMake());
        builder.setModel(device.getModel());
        builder.setOs(OsConvert.getOsType(device.getOs()));
        builder.setOsv(device.getOsVersion());
        builder.setMake(device.getMake());
        builder.setCarrier(getCarrierType(device.getCarrier()));
        builder.setConnectionType(ConnectionTypeConvert.convertConnectionType(device.getTuiaConnectionType()));
        MoYiBidRequest.Geo geo = new MoYiBidRequest.Geo();
        if (Objects.nonNull(device.getGeo())) {
            geo.setCity(device.getGeo().getCity());
            geo.setLon(device.getGeo().getLon().floatValue());
            geo.setLat(device.getGeo().getLat().floatValue());
        }

        request.setDevice(builder);
        request.getDevice().setGeo(geo);
    }

    public void convertApp(MoYiBidRequest request, AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        MoYiBidRequest.App builder = new MoYiBidRequest.App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            String bundle = replaceApp.getBundle();
            String name = replaceApp.getName();
            builder.setPackageName(bundle);
            builder.setName(name);
        } else {
            builder.setPackageName(appInfo.getBundle());
            builder.setName(appInfo.getName());
        }
        builder.setVer(appInfo.getVersion());
        request.setApp(builder);

    }

    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        List<CommonSizeInfo> commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (Objects.nonNull(commonSizeInfo1)) {
                commonSizeInfos.add(commonSizeInfo1);
            }

        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (filterMaterInfo.getWidth().equals(width) && filterMaterInfo.getHeight().equals(height)) {
                return commonSizeInfo;
            }
        }
        return null;
    }
}
