package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 生产上的配置文件
 *
 * @author lizhiheng
 */
@Getter
@AllArgsConstructor
public enum PddTagOnline {

    BAIDU_ADX_76(600, 300, "auto_3", "auto_5"),
    BAIDU_ADX_2447(640, 360, "auto_3", "auto_3"),
    BAIDU_ADX_125(360, 644, "auto_2", "auto_2"),
    BAIDU_ADX_2399(360, 800, "auto_2", "auto_4"),
    ;


    /**
     * 百度流量的样式id
     */
    private Integer width;

    /**
     * 百度流量的样式id
     */
    private Integer height;
    /**
     * pdd的tagid（由我们提供广告位样式，他们给tagId）
     */
    private String tagId;
    /**
     * pdd的template（由我们提供广告位样式，他们给templateId）
     */
    private String templateId;

    public static PddTagOnline getByStyleId(Integer h, Integer w) {
        for (PddTagOnline pddTag : PddTagOnline.values()) {
            if (pddTag.getHeight().equals(h) && pddTag.getWidth().equals(w)) {
                return pddTag;
            }
        }
        return null;
    }
}
