package cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tanx.bean.TanxBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.util.JsonFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Component
@Slf4j
public class TanxResponseConvert {
    public AdxCommonBidResponse respConvert(TanxBiddingResponse.Response response) {
        if (response == null || CollectionUtils.isEmpty(response.getSeatList())) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_5.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response.getSeatList());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<TanxBiddingResponse.Response.Seat> seatList) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        TanxBiddingResponse.Response.Seat seat = seatList.get(0);
        TanxBiddingResponse.Response.Seat.Ad ad = seat.getAd(0);
        String adSource = ad.getAdSource();
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        commonCreative.setAppName(adSource);
        List<CommonImage> imageList = null;
        CommonImage image = new CommonImage();
        List<CommonVideo> videoList = null;
        CommonVideo video = new CommonVideo();

        commonSeatBid.setPrice(Double.parseDouble(String.valueOf(ad.getBidPrice())));
        commonSeatBid.setAdvertiserId("46778");
        List<String> winCallbackUrls = new ArrayList<>();
        winCallbackUrls.add(ad.getWinnoticeUrl());
        commonSeatBid.setWinCallbackUrls(winCallbackUrls);
        commonCreative.setLandingPageUrl(ad.getClickThroughUrl());
        commonCreative.setCreativeId(ad.getCreativeId());
        commonCreative.setDeepLinkUrl(ad.getDeeplinkUrl());
        context.setDeepLinkUrl(ad.getDeeplinkUrl());
        //openType 4表示落地页返回ulink地址
        if (ad.getOpenType() == 4) {
            String ulk = ad.getClickThroughUrl();
            commonCreative.setULinkUrl(ulk);
            context.setULinkUrl(ulk);
        }
        ProtocolStringList impressionTrackingUrlList = ad.getImpressionTrackingUrlList();
        List<String> exposureUrls = new ArrayList<>(impressionTrackingUrlList.size());
        exposureUrls.addAll(impressionTrackingUrlList);
        commonSeatBid.setExposureCallbackUrls(exposureUrls);

        ProtocolStringList clickTrackingUrlList = ad.getClickTrackingUrlList();
        List<String> clickUrls = new ArrayList<>(clickTrackingUrlList.size());
        clickUrls.addAll(clickTrackingUrlList);
        commonSeatBid.setClickCallbackUrls(clickUrls);

        TanxBiddingResponse.Response.Seat.Ad.NativeAd nativeAd = ad.getNativeAd();
        List<TanxBiddingResponse.Response.Seat.Ad.NativeAd.Attr> attrList = nativeAd.getAttrList();
        for (TanxBiddingResponse.Response.Seat.Ad.NativeAd.Attr attr : attrList) {
            String name = attr.getName();
            String value = attr.getValue();
            if ("img_url".equals(name)) {
                image.setUrl(value);
                video.setCoverUrl(value);
            }
            if ("img_width".equals(name)) {
                image.setWidth(Integer.valueOf(value));
                video.setCoverWidth(Integer.valueOf(value));
            }
            if ("img_height".equals(name)) {
                image.setHeight(Integer.valueOf(value));
                video.setCoverHeight(Integer.valueOf(value));
            }
            if ("video".equals(name)) {
                video.setVideoUrl(value);
            }
            if ("video_width".equals(name)) {
                video.setResolutionX(Integer.valueOf(value));
            }
            if ("video_height".equals(name)) {
                video.setResolutionY(Integer.valueOf(value));
            }
            if ("video_duration".equals(name)) {
                video.setDuration(new BigDecimal(value));
            }
            if ("title".equals(name)) {
                CommonTitle commonTitle = new CommonTitle();
                commonTitle.setTitle(value);
                commonCreative.setCommonTitle(commonTitle);
                //标题当描述特殊处理
                CommonDesc commonDesc = new CommonDesc();
                commonDesc.setDesc(value);
                commonCreative.setCommonDesc(commonDesc);
            }
        }
        //tanx video 特殊处理 creativeType不能区分素材类型
        if (StringUtils.isNotBlank(video.getVideoUrl())) {
            videoList = new ArrayList<>();
            videoList.add(video);
            commonCreative.setCommonVideoList(videoList);
        } else {
            imageList = new ArrayList<>();
            imageList.add(image);
            commonCreative.setCommonImageList(imageList);
        }
        return commonSeatBidList;
    }
}
