package cn.com.duiba.tuia.dsp.engine.api.dsp.lingmo;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.resp.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Slf4j
@Component
public class LingMoDspInvoker extends AbstractDspCaller<BidResponse, BidRequest> {
    @Autowired
    private TuiaReqConvert reqConvert;

    @Autowired
    private TuiaRespConvert respConvert;

    @Autowired
    private LingMoProperties lingMoProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount("领摩DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(lingMoProperties.getUrl(), bidRequest), "invokeDSP", "lingmo");
        } catch (Throwable t) {
            Cat.logMetricForCount("启航_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("启航调用异常", t);
            }
        }

        return null;
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity<BidRequest> requestEntity = new HttpEntity<>(bidRequest, headers);
        ResponseEntity<BidResponse> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, BidResponse.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("领摩调用异常 response is {}", resEntity, e);
            }
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        if (statusCode == HttpStatus.NO_CONTENT) {
            return null;
        }
        return resEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String key = "071c928deefa39aed8ac0c9bfad82a8e";
        String code = price.toString();
        byte[] keyBytes = key.getBytes();
        try {
            SecretKeySpec sckeySpec = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, sckeySpec);
            byte[] encrypted = cipher.doFinal(code.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encrypted);
        } catch (Exception e) {
            log.warn("领摩加密失败", e);
        }

        return "";
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_13.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_13;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            return url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        bidResponse.setDspId(getDspId());
        return respConvert.convert(bidResponse);
    }
}
