package cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
public class FireflyRespConvert {

    public AdxCommonBidResponse convert(FireFlyResp fireFlyResp) {
        if (fireFlyResp == null) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setDspId(DspEnum.DSP_14.getDspId());
        List<SeatBid> seatBid = fireFlyResp.getSeatBid();
        List<CommonSeatBid> commonSeatBids = seatBidConvert(seatBid);
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<SeatBid> seatBid) {
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        Bid bid = seatBid.get(0).getBid().get(0);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        commonSeatBid.setExposureCallbackUrls(bid.getShowUrl());
        commonSeatBid.setClickCallbackUrls(bid.getClickUrl());
        commonSeatBid.setWinCallbackUrls(bid.getNurl());
        commonSeatBid.setPrice((double) bid.getPrice());
        Adm adm = bid.getAdm();
        if (StringUtils.isNotBlank(adm.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(adm.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (StringUtils.isNotBlank(adm.getIcon())) {
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getIcon());
            commonCreative.setCommonIcon(commonIcon);
        }
        if (adm.getVideoInfo() != null) {
            List<CommonVideo> commonVideoList = new ArrayList<>();
            Video videoInfo = adm.getVideoInfo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(videoInfo.getUrl());
            commonVideo.setResolutionX(videoInfo.getWidth());
            commonVideo.setResolutionY(videoInfo.getHeight());
            if (videoInfo.getDuration() != 0) {
                commonVideo.setDuration(new BigDecimal(videoInfo.getDuration()));
            }
            commonVideo.setSize(videoInfo.getSize());
            commonVideo.setCoverUrl(videoInfo.getCoverUrl());
            commonVideo.setCoverWidth(videoInfo.getCoverWidth());
            commonVideo.setCoverHeight(videoInfo.getCoverHeight());
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else {
            Image image = adm.getImgInfo().get(0);
            List<CommonImage> commonImageList = new ArrayList<>();
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image.getUrl());
            commonImage.setWidth(image.getWidth());
            commonImage.setHeight(image.getHeight());
            commonImageList.add(commonImage);
            commonCreative.setCommonImageList(commonImageList);
        }
        if (adm.getAndroidApp() != null) {
            AndroidApp androidApp = adm.getAndroidApp();
            commonCreative.setAppBundle(androidApp.getPackageName());
            commonCreative.setAppName(androidApp.getAppName());
        }
        if (adm.getLandingpage() != null) {
            String url = adm.getLandingpage().getUrl();
            commonCreative.setLandingPageUrl(url);
        }
        if (StringUtils.isNotBlank(adm.getDeeplink())) {
            commonCreative.setDeepLinkUrl(adm.getDeeplink());
            context.setDeepLinkUrl(adm.getDeeplink());
        }

        return commonSeatBidList;
    }
}
