package cn.com.duiba.tuia.dsp.engine.api.dsp.moyi.bean;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * Created by hong
 * time 2023/8/21.
 */
@Data
public class MoYiBidResponse {

    private String id;

    @JSONField(name ="seat_bid")
    @JsonProperty("seat_bid")
    private List<SeatBid> seatBids;


    @Data
    public static class SeatBid {

        private List<Bid> bid;


    }

    @Data
    public static class Bid {

        private String id;

        @JSONField(name ="imp_id")
        @JsonProperty("imp_id")
        private String impId;

        private float price;

        private Ext ext;


    }

    @Data
    public static class Ext {

        private Material material;

        private Tracking tracking;


    }

    @Data
    public static class Material {

        @JSONField(name ="ad_type")
        @JsonProperty("ad_type")
        private int adType;

        private String icon;

        private List<Image> images;

        private String title;

        private String desc;

        private List<Video> video;

        @JSONField(name ="download_type")
        @JsonProperty("download_type")
        private int downloadType;

        private String ldp;

        private String durl;

        @JSONField(name ="download_url")
        @JsonProperty("download_url")
        private String downloadUrl;

        @JSONField(name ="package")
        @JsonProperty("package")
        private String packageName;

        @JSONField(name ="itunes_id")
        @JsonProperty("itunes_id")
        private String itunesId;

        @JSONField(name ="app_info")
        @JsonProperty("app_info")
        private AppInfo appInfo;


    }

    @Data
    public static class Image {

        private String url;

        private String width;

        private String height;


    }

    @Data
    public static class AppInfo {

        private String name;

        @JSONField(name ="icon_url")
        @JsonProperty("icon_url")
        private String iconUrl;

        @JSONField(name ="download_url")
        @JsonProperty("download_url")
        private String downloadUrl;

        private int size;

        @JSONField(name ="version_name")
        @JsonProperty("version_name")
        private String versionName;

        @JSONField(name ="package_name")
        @JsonProperty("package_name")
        private String packageName;

        private String developer;

        @JSONField(name ="permission_url")
        @JsonProperty("permission_url")
        private String permissionUrl;

        @JSONField(name ="privacy_url")
        @JsonProperty("privacy_url")
        private String privacyUrl;

        private String description;


    }
    @Data
    public static class Video {

        private String videoImg;

        @JSONField(name ="vurl")
        @JsonProperty("vurl")
        private String videoUrl;

        private int width;

        private int height;

        private int duration;

        @JSONField(name ="video_title")
        @JsonProperty("video_title")
        private String videoTitle;

        // getter和setter方法

    }


    @Data
    public static class Tracking {

        private List<String> pnurl;

        @JSONField(name ="report_impress")
        @JsonProperty("report_impress")
        private List<String> reportImpress;

        @JSONField(name ="report_click")
        @JsonProperty("report_click")
        private List<String> reportClick;

        @JSONField(name ="report_other")
        @JsonProperty("report_other")
        private List<ReportOther> reportOther;


    }

    @Data
    public static class ReportOther {

        private int type;

        private List<String> urls;


    }
}
