package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;


import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author lizhiheng
 */
@Component
@Slf4j
public class IqiyiRespConvert {

    public AdxCommonBidResponse respConvert(IqiyiBid.BidResponse response) {
        if (response == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(response.getBidList())) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_16.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response.getBidList());
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<IqiyiBid.BidResponse.Bid> bidList) {
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        for (IqiyiBid.BidResponse.Bid bid : bidList) {
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext context = new CommonContext();
            CommonCreative commonCreative = new CommonCreative();

            if (Objects.nonNull(bid)) {
                commonSeatBid.setPrice((double) bid.getPrice());
                commonSeatBid.setAdvertiserId("");
                IqiyiBid.BidResponse.Bid.Link link = bid.getLink();

                IqiyiBid.BidResponse.Bid.AdmNative admnative = bid.getAdmnative();
                IqiyiBid.BidResponse.Bid.AdmVideo admvideo = bid.getAdmvideo();
                commonSeatBid.setWinCallbackUrls(bid.getWinNoticeUrlList());
                commonCreative.setCreativeId(bid.getCrid());
                if (Objects.nonNull(admnative)) {
                    IqiyiBid.BidResponse.Bid.Link admnativeLink = admnative.getLink();
                    commonCreative.setLandingPageUrl(admnativeLink.getCurl());
                    commonCreative.setDeepLinkUrl(admnativeLink.getDeeplink());
                    context.setDeepLinkUrl(admnativeLink.getDeeplink());
                    commonSeatBid.setExposureCallbackUrls(admnativeLink.getImptrackersList());
                    commonSeatBid.setClickCallbackUrls(admnativeLink.getClicktrackersList());
                } else if (Objects.nonNull(admvideo)) {
                    IqiyiBid.BidResponse.Bid.Link admvideoLink = admvideo.getLink();
                    commonCreative.setLandingPageUrl(admvideoLink.getCurl());
                    commonCreative.setDeepLinkUrl(admvideoLink.getDeeplink());
                    context.setDeepLinkUrl(admvideoLink.getDeeplink());
                    commonSeatBid.setExposureCallbackUrls(admvideoLink.getImptrackersList());
                    commonSeatBid.setClickCallbackUrls(admvideoLink.getClicktrackersList());
                }
                processAdmContent(bid, commonCreative);
                commonSeatBidList.add(commonSeatBid);
            }
            commonSeatBid.setCommonContext(context);
            commonSeatBid.setCommonCreative(commonCreative);
        }

        return commonSeatBidList;
    }


    private void processAdmContent(IqiyiBid.BidResponse.Bid bid, CommonCreative commonCreative) {
        processNativeContent(bid.getAdmnative(), commonCreative);
        processVideoContent(bid.getAdmvideo(), commonCreative);
    }


    private void processNativeContent(IqiyiBid.BidResponse.Bid.AdmNative admNative, CommonCreative commonCreative) {
        if (StringUtils.isNotEmpty(admNative.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(admNative.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }

        if (CollectionUtils.isNotEmpty(admNative.getImgsList())) {
            List<CommonImage> imageList = new ArrayList<>();
            for (IqiyiBid.BidResponse.Bid.Image img : admNative.getImgsList()) {
                CommonImage image = new CommonImage();
                image.setUrl(img.getUrl());
                image.setWidth(img.getW());
                image.setHeight(img.getH());
                imageList.add(image);
            }
            commonCreative.setCommonImageList(imageList);
        }

        List<CommonVideo> videoList = new ArrayList<>();
        IqiyiBid.BidResponse.Bid.Video video = admNative.getVideo();
        CommonVideo commonVideo = new CommonVideo();
        commonVideo.setVideoUrl(video.getUrl());
        commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
        commonVideo.setCoverUrl(video.getStartCover());
        videoList.add(commonVideo);
        commonCreative.setCommonVideoList(videoList);

        if (Objects.isNull(commonCreative.getCommonTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle("惊喜");
            commonCreative.setCommonTitle(commonTitle);
        }
    }

    private void processVideoContent(IqiyiBid.BidResponse.Bid.AdmVideo admVideo, CommonCreative commonCreative) {
        if (StringUtils.isNotEmpty(admVideo.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(admVideo.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }

        if (CollectionUtils.isNotEmpty(admVideo.getImgsList())) {
            List<CommonImage> imageList = new ArrayList<>();
            for (IqiyiBid.BidResponse.Bid.Image img : admVideo.getImgsList()) {
                CommonImage image = new CommonImage();
                image.setUrl(img.getUrl());
                image.setWidth(img.getW());
                image.setHeight(img.getH());
                imageList.add(image);
            }
            commonCreative.setCommonImageList(imageList);
        }

        List<CommonVideo> videoList = new ArrayList<>();
        IqiyiBid.BidResponse.Bid.Video video = admVideo.getVideo();
        CommonVideo commonVideo = new CommonVideo();
        commonVideo.setVideoUrl(video.getUrl());
        commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
        commonVideo.setCoverUrl(video.getStartCover());
        videoList.add(commonVideo);
        commonCreative.setCommonVideoList(videoList);

        if (Objects.isNull(commonCreative.getCommonTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle("惊喜");
            commonCreative.setCommonTitle(commonTitle);
        }
    }
}
