package cn.com.duiba.tuia.dsp.engine.api.dsp.jutui;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.util.CatUtils;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.resp.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Slf4j
@Component
public class JutuiDspInvoker extends AbstractDspCaller<BidResponse, BidRequest> {

    @Autowired
    private TuiaReqConvert reqConvert;

    @Autowired
    private TuiaRespConvert respConvert;

    @Autowired
    private JutuiDspProperties jutuiProperties;

    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount("聚推DSP调用");
        try {
            log.info("yqf url:{}", jutuiProperties.getUrlNew());
            final BidResponse bidResponse = CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(jutuiProperties.getUrlNew(), bidRequest), "invokeDSP", "jutui");
            log.info("yqf url:{} bidResponse:{}", jutuiProperties.getUrlNew(), JSON.toJSONString(bidResponse));
            return bidResponse;
        } catch (Throwable t) {
            log.info("yqf  error url:{}", jutuiProperties.getUrlNew());
            Cat.logMetricForCount("聚推_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("聚推调用异常", t);
            }
        }
        return null;
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "application/json");
        HttpEntity<BidRequest> requestEntity = new HttpEntity<>(bidRequest, headers);
        ResponseEntity<BidResponse> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, BidResponse.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("聚推调用异常 response is {}", resEntity, e);
            }
        }
        if (resEntity == null) {
            return null;
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        if (statusCode == HttpStatus.NO_CONTENT) {
            return null;
        }
        SamplerLog.info("聚推 DSP返回 {}", resEntity);
        Cat.logMetricForCount("聚推DSP返回");
        return resEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String key = "ngmqKoFoAEcQKW5jFCZooJFcLGhQT0f8";
        String code = price.toString();
        byte[] keyBytes = key.getBytes();
        try {
            SecretKeySpec sckeySpec = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, sckeySpec);
            byte[] encrypted = cipher.doFinal(code.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encrypted);
        } catch (Exception e) {
            log.warn("聚推加密失败", e);
        }
        return "";
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_26.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_26;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            return url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse == null) {
            return null;
        }
        bidResponse.setDspId(getDspId());
        return respConvert.convert(bidResponse);
    }
}
