/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.alipay;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.alipay.AlipayProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonCreative;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.CommonSeatBid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.convert.TuiaRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.req.BidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.tuia.resp.BidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class AlipayDspInvoker
extends AbstractDspCaller<BidResponse, BidRequest> {
    private static final Logger log = LoggerFactory.getLogger(AlipayDspInvoker.class);
    @Autowired
    private TuiaReqConvert reqConvert;
    @Autowired
    private TuiaRespConvert respConvert;
    @Autowired
    private AlipayProperties alipayProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BidResponse invokeDsp(BidRequest bidRequest) {
        if (bidRequest == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u652f\u4ed8\u5b9dDSP\u8c03\u7528");
        try {
            return (BidResponse)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.alipayProperties.getUrl(), bidRequest), (String)"invokeDSP", (String)"alipay");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u652f\u4ed8\u5b9d_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u652f\u4ed8\u5b9d\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private BidResponse doHttpInvoke(String url, BidRequest bidRequest) {
        ResponseEntity resEntity;
        block4: {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            headers.add("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)bidRequest, (MultiValueMap)headers);
            resEntity = null;
            try {
                resEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, BidResponse.class, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof RestClientException) break block4;
                log.warn("\u652f\u4ed8\u5b9d\u8c03\u7528\u5f02\u5e38 response is {}", (Object)resEntity, (Object)e);
            }
        }
        if (resEntity == null) {
            return null;
        }
        HttpStatus statusCode = resEntity.getStatusCode();
        if (statusCode == HttpStatus.NO_CONTENT) {
            return null;
        }
        SamplerLog.info((String)"\u652f\u4ed8\u5b9d DSP\u8fd4\u56de {}", (Object[])new Object[]{resEntity});
        Cat.logMetricForCount((String)"\u652f\u4ed8\u5b9dDSP\u8fd4\u56de");
        return (BidResponse)resEntity.getBody();
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        String key = "ngmqKoFoAEcQKW5jFCZooJFcLGhQT0f8";
        String code = price.toString();
        byte[] keyBytes = key.getBytes();
        try {
            SecretKeySpec sckeySpec = new SecretKeySpec(keyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, sckeySpec);
            byte[] encrypted = cipher.doFinal(code.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            log.warn("\u652f\u4ed8\u5b9d\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_25.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_25;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            return url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public BidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.reqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BidResponse bidResponse) throws DspException {
        if (bidResponse == null) {
            return null;
        }
        bidResponse.setDspId(this.getDspId());
        AdxCommonBidResponse convert = this.respConvert.convert(bidResponse);
        CommonSeatBid commonSeatBid = convert.getCommonSeatBidList().get(0);
        CommonCreative commonCreative = commonSeatBid.getCommonCreative();
        String deepLinkUrl = commonCreative.getDeepLinkUrl();
        String taskId = this.getTaskId(deepLinkUrl);
        commonCreative.setDspTaskId(taskId);
        return convert;
    }

    private String getTaskId(String deepLinkUrl) {
        if (StringUtils.isBlank((CharSequence)deepLinkUrl)) {
            return null;
        }
        try {
            deepLinkUrl = URLDecoder.decode(deepLinkUrl, StandardCharsets.UTF_8.toString());
            if (deepLinkUrl.contains("taskId")) {
                String[] params;
                for (String param : params = deepLinkUrl.split("&")) {
                    String[] keyValue;
                    if (!param.startsWith("taskId") || (keyValue = param.split("=")).length != 2) continue;
                    return keyValue[1];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

