package cn.com.duiba.tuia.dsp.engine.api.dsp.firefly;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.FireFlyReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.bean.FireFlyResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert.FireflyReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.firefly.convert.FireflyRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.annotation.Resource;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;

@Component
@Slf4j
public class FireflyDspInvoker extends AbstractDspCaller<FireFlyResp, FireFlyReq> {
    @Autowired
    private FireflyReqConvert fireflyReqConvert;
    @Autowired
    private FireflyRespConvert fireflyRespConvert;
    @Autowired
    private FireflyProperties fireflyProperties;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected FireFlyResp invokeDsp(FireFlyReq fireFlyReq) {
        if (fireFlyReq == null) {
            return null;
        }
        Cat.logMetricForCount("萤火虫DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(fireflyProperties.getUrl(), fireFlyReq), "invokeDSP", "firefly");
        } catch (Throwable t) {
            Cat.logMetricForCount("萤火虫_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("萤火虫调用异常", t);
            }
        }
        return null;
    }

    private FireFlyResp doHttpInvoke(String url, FireFlyReq fireFlyReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        long timestamp = System.currentTimeMillis() / 1000;
        headers.add("ff-timestamp", timestamp + "");
        String sign = sign(timestamp);
        headers.add("ff-authorization", "10027:" + sign);
        HttpEntity<FireFlyReq> requestEntity = new HttpEntity<>(fireFlyReq, headers);
        ResponseEntity<FireFlyResp> resEntity = null;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, FireFlyResp.class);
        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                log.warn("萤火虫调用异常 response is {}", resEntity, e);
            }
            return null;
        }
        FireFlyResp body = resEntity.getBody();
        SamplerLog.info("萤火虫 response is {}", body);
        if (body == null || body.getNbr() != 0) {
            return null;
        }
        Cat.logMetricForCount("萤火虫DSP返回");
        return body;
    }

    private String sign(long timestamp) {
        int accountId = 10027;
        String data = String.format("%d_%d_%s", timestamp, accountId, fireflyProperties.getSecret());
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(data.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) hexString.append('0');
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            //ignore
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_14.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_14;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        url = url.replace("${__AUCTION_PRICE__}", price);
        return url;
    }

    @Override
    public FireFlyReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return fireflyReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(FireFlyResp fireFlyResp) throws DspException {
        return fireflyRespConvert.convert(fireFlyResp);
    }
}
