package cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.guangtui.bean.Guangtui;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
public class GuangtuiResponseConverter {

    public AdxCommonBidResponse respConvert(Guangtui.Response rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_22.getDspId());
        adxCommonBidResponse.setRequestId(rtbResponse.getId());
        List<CommonSeatBid> commonSeatBids = seatConvert(rtbResponse);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(Guangtui.Response rtbResponse) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        List<Guangtui.Bid> bidList= rtbResponse.getSeatbid().getBidList();
        if (CollectionUtils.isEmpty(bidList)) {
            return commonSeatBidList;
        }

        // 遍历所有广告位
        for (Guangtui.Bid slotAd : bidList) {
            // 遍历广告位中的广告
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            // 设置基础信息（与工程中其他DSP保持相同结构）
            commonSeatBid.setAdvertiserId("44910"); // 固定值与其他DSP对齐


            // 构建创意信息
            CommonCreative commonCreative = new CommonCreative();
            Guangtui.Adm adm = slotAd.getAdm();
            commonSeatBid.setPriceType(0);
            commonSeatBid.setPrice((double) slotAd.getPrice());
            // 标题处理
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adm.getTitle());
            commonCreative.setCommonTitle(commonTitle);
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adm.getDesc());
            commonCreative.setCommonDesc(commonDesc);
            // Logo处理
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(adm.getIcon());
            commonCreative.setCommonIcon(commonIcon);
            commonCreative.setAppName(slotAd.getAppName());
            commonCreative.setAppBundle(slotAd.getPackageName());
            commonCreative.setDownloadUrl(slotAd.getDownloadUrl());
            commonCreative.setIconUrl(adm.getIcon());
            commonCreative.setDeepLinkUrl(slotAd.getTargetUrl());
            commonCreative.setULinkUrl(slotAd.getTargetUrl());
            commonCreative.setLandingPageUrl(slotAd.getLandingUrl());


            // 添加上下文信息
            CommonContext context = new CommonContext();
            context.setULinkUrl(slotAd.getTargetUrl());
            commonSeatBid.setCommonContext(context);

            // 视频处理
            Guangtui.Video video = adm.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setDuration(new BigDecimal(video.getDuration()));
            commonVideo.setSize(video.getFileSize());
            commonVideo.setCoverWidth(video.getW());
            commonVideo.setCoverHeight(video.getH());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));

            // 图片处理
            if (adm.getImgCount() > 0) {

                List<CommonImage> commonImageList = Lists.newArrayList();
                for (Guangtui.Image image : adm.getImgList()) {
                    CommonImage commonImage = new CommonImage();
                    commonImage.setUrl(image.getUrl());
                    commonImage.setWidth(image.getW());
                    commonImage.setHeight(image.getH());
                    commonImageList.add(commonImage);
                }
                commonCreative.setCommonImageList(commonImageList);
            }

            // 设置回调URL（根据demo中的字段映射）
            Guangtui.Tracking tracking = slotAd.getTracking();
            commonSeatBid.setWinCallbackUrls(tracking.getNoticeUrlsList());
            commonSeatBid.setExposureCallbackUrls(tracking.getImpTrackersList());
            commonSeatBid.setClickCallbackUrls(tracking.getClickTrackersList());

            commonSeatBid.setCommonCreative(commonCreative);
            commonSeatBidList.add(commonSeatBid);
        }

        return commonSeatBidList;
    }


}
