package cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter.HuichuanRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.converter.HuichuanResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.req.AdRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.resp.HuichuanResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.RgyunProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunRequestConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter.RgyunResponseConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.REQ_PARAM_CONVERT_ERROR;
import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.RESP_PARAM_CONVERT_ERROR;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
@Slf4j
public class HuichuanDspInvoker extends AbstractDspCaller<HuichuanResponse, AdRequest> {

    private static final String TOKEN = "d6797b0f95f8ead2";

    @Resource
    private HuichuanRequestConverter huichuanRequestConverter;

    @Resource
    private HuichuanResponseConverter huichuanResponseConverter;

    @Resource
    private HuichuanProperties huichuanProperties;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Override
    protected HuichuanResponse invokeDsp(AdRequest rtbRequest) {
        if (rtbRequest == null) {
            return null;
        }
        Cat.logMetricForCount("超级汇川DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(huichuanProperties.getUrl(), rtbRequest), "invokeDSP", "huichuan");
        } catch (Throwable t) {
            Cat.logMetricForCount("超级汇川_竞价失败");
            if (!(t instanceof SocketTimeoutException || t instanceof ResourceAccessException)) {
                SamplerLog.warn("超级汇川竞价失败", t);
            }
            return null;
        }
    }

    private HuichuanResponse doHttpInvoke(String url, AdRequest rtbRequest) throws IOException {

        Charset utf8 = Consts.UTF_8;
        byte[] paramByte = JSON.toJSONString(rtbRequest).getBytes(utf8);
        byte[] requestByte = new byte[paramByte.length + 16];
        requestByte[1] = 2;
        System.arraycopy(paramByte, 0, requestByte, 16, paramByte.length);

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");

        HttpEntity<byte[]> requestEntity = new HttpEntity<>(requestByte, headers);
        ResponseEntity<org.springframework.core.io.Resource> resEntity;
        try {
            resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, org.springframework.core.io.Resource.class);
            org.springframework.core.io.Resource resource = resEntity.getBody();
            if (resource == null) {
                return null;
            }
            HttpStatus statusCode = resEntity.getStatusCode();
            byte[] responseBytes = IOUtils.toByteArray(resource.getInputStream());
            if (responseBytes == null || responseBytes.length <= 16) {
                SamplerLog.info("超级汇川DSP内容返回不规范,pddRequest[{}],body[{}]", rtbRequest);
                return null;
            }

            byte[] response = new byte[responseBytes.length - 16];
            System.arraycopy(responseBytes, 16, response, 0, response.length);
            HuichuanResponse huichuanResponse = JSON.parseObject(new String(response, utf8), HuichuanResponse.class);

            if (HttpStatus.OK.value() == statusCode.value()) {
                if (huichuanResponse.getCode().equals(0)) {
                    Cat.logMetricForCount("超级汇川DSP返回");
                    return huichuanResponse;
                }else {
                    SamplerLog.info("超级汇川DSP返回错误码或者冷启动,pddRequest[{}],body[{}]", rtbRequest, huichuanResponse);
                    Cat.logMetricForCount("超级汇川DSP返回错误码");
                    return null;
                }
            } else if (statusCode.is5xxServerError()) {
                Cat.logMetricForCount("超级汇川返回5xx");
                SamplerLog.info("超级汇川返回5xx,pddRequest[{}],body[{}]", rtbRequest, huichuanResponse);
                return null;
            } else {
                Cat.logMetricForCount("超级汇川返回其他状态码");
                SamplerLog.info("超级汇川返回其他状态码,pddRequest[{}],body[{}]", rtbRequest, huichuanResponse);
                return null;
            }

        } catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                SamplerLog.warn("超级汇川调用异常", e);
            }
            return null;
        }

    }


    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            byte[] raw = TOKEN.getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            IvParameterSpec iv = new IvParameterSpec(raw);
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
            byte[] encrypted = cipher.doFinal(price.toString().getBytes("utf-8"));
            byte[] encodeBase64 = Base64.encodeBase64URLSafe(encrypted);
            return new String(encodeBase64, "utf-8");
        } catch (Exception e) {
            log.warn("RgyunDspInvoker 价格解密失败");
            return null;
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_21.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_21;
    }

    @Override
    public AdRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return huichuanRequestConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }
    }

    @Override
    public AdxCommonBidResponse convertResp(HuichuanResponse rtbResponse) throws DspException {
        try {
            return huichuanResponseConverter.respConvert(rtbResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("${AUCTION_PRICE}") && price != null) {
            url = url.replace("${AUCTION_PRICE}", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }
}
