package cn.com.duiba.tuia.dsp.engine.api.dsp.huichuan.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;

@Data
public class HuichuanResponse {
    private Integer code;
    private String sid;
    private String reason;
    private List<SlotAd> slot_ad;

    @Data
    public static class SlotAd {
        private Integer slot_id;
        private List<Ad> ad;
        private List<AdExtInfo> ad_ext_info;
    }

    @Data
    public static class Ad {
        private AdAction ad_action;
        private AdContent ad_content;
        private Long ad_id;
        private Integer style;
        private Integer rank;
        private String furl;
        private List<String> turl;
        private List<String> vurl;
        private List<String> curl;
        private String wnurl;
        private String click_area_report_url;
        private List<Integer> convert_type;
        private String eurl;
        private String video_play_url;
        private String scheme_feedback_url;
        private Long expired_time;
    }

    @Data
    public static class AdAction {
        private String action;
    }

    @Data
    public static class AdContent {
        // 基础字段
        private String style;
        private String title;
        private String source;

        // 图片资源
        private String img_1;
        private String img_2;
        private String img_3;
        private String img_1_h;
        private String img_1_w;
        private String img_1_t;

        // 视频资源（字段名前加v_规避数字开头）
        @JSONField(name = "1_video_aliyun")
        private String v_1_video_aliyun;
        @JSONField(name = "1_video_duration")
        private String v_1_video_duration;
        @JSONField(name = "1_video_size")
        private String v_1_video_size;

        // 下载相关
        private String download_url;
        private String package_name;
        private String version_name;
        private String app_name;
        private String app_logo;
        private String developer;
        private String button_content;

        // 深度链接
        private String scheme;
        private String scheme_url_ad;
        private String market_direct_url;

        // 安全合规
        private String permission;
        private String privacy;
        private String function_desc;

        // 小程序
        private String mini_app_id;
        private String mini_app_path;

        // 广告主信息
        private Integer account_id;
        private Integer dsp_bid_price;
        private String dsp_logo;
        private String dsp_name;

        // iOS专用
        private String adm_fixed_ulk;
        private String app_key;

        // 其他字段
        private String logo_url;
        private String update_time;
        private String xiaomi_creative_id;

    }

    @Data
    public static class AdExtInfo {
        private String key;
        private String value;
    }
}
