package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.JuMeiReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.JuMeiResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert.JuMeiReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert.JuMeiRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;

@Component
@Slf4j
public class JuMeiDspInvoker extends AbstractDspCaller<JuMeiResp, JuMeiReq> {
    @Autowired
    private JuMeiReqConvert juMeiReqConvert;
    @Autowired
    private JuMeiRespConvert juMeiRespConvert;
    @Resource(name = "dspRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private JuMeiProperties juMeiProperties;

    @Override
    protected JuMeiResp invokeDsp(JuMeiReq juMeiReq) {
        if (juMeiReq == null) {
            return null;
        }
        Cat.logMetricForCount("聚媒DSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(juMeiProperties.getUrl(), juMeiReq), "invokeDSP", "jumei");
        } catch (Throwable t) {
            Cat.logMetricForCount("聚媒_竞价失败");
            if (!(t instanceof RestClientException || t instanceof SocketTimeoutException)) {
                SamplerLog.warn("聚媒调用异常", t);
            }
        }
        return null;
    }

    private JuMeiResp doHttpInvoke(String url, JuMeiReq juMeiReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<JuMeiReq> httpEntity = new HttpEntity<>(juMeiReq, headers);
        ResponseEntity<JuMeiResp> responseEntity = null;
        try {
            responseEntity = restTemplate.postForEntity(url, httpEntity, JuMeiResp.class);
        } catch (Exception e) {
            log.warn("聚媒调用异常", e);
        }
        if (responseEntity == null) {
            return null;
        }
        JuMeiResp body = responseEntity.getBody();
        if (body != null && body.getCode() == 200) {
            Cat.logMetricForCount("聚媒DSP返回");
            return body;
        }
        return null;
    }


    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_15.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_15;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (StringUtils.isNotEmpty(price)) {
            return url.replace("__MF_LOSS_PR__", price);
        }
        return url;
    }

    @Override
    public JuMeiReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return juMeiReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(JuMeiResp juMeiResp) throws DspException {
        if (juMeiResp != null && juMeiResp.getCode() == 200) {
            return juMeiRespConvert.convert(juMeiResp);
        }
        return null;
    }
}
