package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean;

import lombok.Data;

@Data
public class Device {
    //0:Unknown 1:IOS 2:Android 5:Windows 7:HarmonyOs
    private Integer osType;
    //设备类型:
    //0:其它
    //1:手机
    //2:平板
    //3:OTT 终端
    //4:PC
    //注:OTT 终端包括互联网电视和电视机顶盒
    private Integer type;
    //设备系统版本
    private String osVersion;
    //系统 UI 版本号，小米 MIUI 版本，或者华为 UI 版 本号等
    private String osUiVersion;
    //Android API 版本
    private Integer androidApiLevel;
    //系统初始化时间 ios
    private String sysCompilingTime;
    //系统最近一次更新时间 ios
    private String sysUpdateTime;
    //系统最近一次启动时间
    private String sysStartupTime;
    //IOS 设备初始化标识
    private String birthMark;
    //系统启动标识
    private String bootMark;
    //系统更新标识
    private String updateMark;
    //设备 ROM 版本
    private String romVersion;
    //设备名称 ios
    private String deviceName;
    //设备名称 md5 值
    private String deviceNameMd5;
    //设备 CPU 核数
    private Integer cpuNum;
    //磁盘大小 字节
    private Long sysDiskSize;
    //设备内存大小 字节
    private Long sysMemorySize;
    //设备型号
    private String model;
    //IOS 硬件型号
    private String hardwareModel;
    //设备系统语言
    private String language;
    //系统当前时区
    private String timeZone;
    //华为 HMS Core 版本
    private String hmsVersion;
    //鸿蒙系统内核版本
    private String harmonyOsVersion;
    //华为 AppGallery 应用市场版本
    private String hagVersion;
    //媒体是否支持 deeplink 0:否 1:是
    private Integer supportDeeplink;
    //媒体是否支持 universal link: 0:否 1:是
    private Integer supportUniversal;
    //设备厂商
    private String make;
    //设备品牌
    private String brand;
    //国际移动用户识别码
    private String imsi;
    //设备屏幕宽度
    private Integer width;
    //设备屏幕高度
    private Integer height;
    //设备屏幕物理像素密度
    private Double density;
    //设备屏幕像素点密度，表示每英寸的点数
    private Integer dpi;
    //设备屏幕像素密度，表示每英寸的像素数
    private Integer ppi;
    //屏幕的方向:0:unknown 1:竖屏 2:横屏
    private Integer orientation;
    //屏幕尺寸，单位:英寸
    private String screenSize;
    //设备序列号
    private String serialno;
}
