package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
public class JuMeiRespConvert {
    public AdxCommonBidResponse convert(JuMeiResp juMeiResp) {
        List<AdInfo> data = juMeiResp.getData();
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_15.getDspId());
        List<CommonSeatBid> commonSeatBids = seatBidConvert(data);
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatBidConvert(List<AdInfo> data) {
        AdInfo adInfo = data.get(0);
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        commonSeatBidList.add(commonSeatBid);
        CommonContext context = new CommonContext();
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        commonSeatBid.setCommonCreative(commonCreative);
        if (StringUtils.isNotBlank(adInfo.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(adInfo.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(adInfo.getDesc())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(adInfo.getDesc());
            commonCreative.setCommonDesc(commonDesc);
        }
        commonCreative.setDeepLinkUrl(adInfo.getDeeplink());
        context.setDeepLinkUrl(adInfo.getDeeplink());
        commonCreative.setULinkUrl(adInfo.getUniversalLink());
        context.setULinkUrl(adInfo.getUniversalLink());
        commonCreative.setLandingPageUrl(adInfo.getLandingPageUrl());
        commonSeatBid.setPrice(adInfo.getBidPrice().doubleValue());
        commonSeatBid.setWinCallbackUrls(adInfo.getWinNoticeUrls());
        if (adInfo.getApp() != null) {
            AppRsp app = adInfo.getApp();
            commonCreative.setAppName(app.getName());
            commonCreative.setAppBundle(app.getPkgName());
            commonCreative.setIconUrl(app.getIconUrl());
        }
        if (adInfo.getVideo() != null) {
            List<CommonVideo> commonVideoList = new ArrayList<>();
            CommonVideo commonVideo = new CommonVideo();
            Video video = adInfo.getVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setCoverUrl(video.getCoverUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            if (video.getDuration() != null) {
                commonVideo.setDuration(new BigDecimal(video.getDuration()));
            }
            commonVideo.setSize(video.getSize());
            commonVideoList.add(commonVideo);
            commonCreative.setCommonVideoList(commonVideoList);
        } else {
            List<CommonImage> commonImageList = new ArrayList<>();
            List<Image> images = adInfo.getImages();
            for (Image image : images) {
                CommonImage commonImage = new CommonImage();
                commonImage.setUrl(image.getUrl());
                commonImage.setWidth(image.getWidth());
                commonImage.setHeight(image.getHeight());
                commonImageList.add(commonImage);
            }
            commonCreative.setCommonImageList(commonImageList);
        }
        Track track = adInfo.getTrack();
        List<String> showUrls = track.getShowUrls();
        commonSeatBid.setExposureCallbackUrls(showUrls);
        commonSeatBid.setClickCallbackUrls(track.getClickUrls());

        return commonSeatBidList;
    }
}
