package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import cn.com.duiba.tuia.dsp.engine.api.util.UAUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import static cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass.CostType.COSTTYPE_CPM;


/**
 * @author lizhiheng
 */
@Component
@Slf4j
public class KuaishouDspRequestConverter {
    @Autowired
    private AppReplace appReplace;

    public KuaishouBidRequestOuterClass.KuaishouBidRequest reqConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Builder builder = KuaishouBidRequestOuterClass.KuaishouBidRequest.newBuilder();
        //设置imp对象
        builder.addImpressions(this.convertImp(adxCommonBidRequest, dspInfo));

        //设置device对象
        builder.setId(adxCommonBidRequest.getRequestId());
        builder.setDevice(this.convertDevice(adxCommonBidRequest.getDevice(), adxCommonBidRequest.getAdxType()));
        builder.setIp(optionOfNull(adxCommonBidRequest.getDevice().getIp()));
        //设置user对象
        builder.setGeo(this.convertGeo(adxCommonBidRequest.getDevice().getGeo()));
        //设置app对象
        builder.setApp(convertApp(adxCommonBidRequest.getAppInfo(), dspInfo));

        return builder.build();
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Device convertDevice(CommonDevice device, Integer adxType) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Device.Builder deviceBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Device.newBuilder();
        if (Objects.isNull(device)) {
            return deviceBuilder.build();
        }
        deviceBuilder.setDeviceType(DeviceTypeConverter.getDeviceType(device.getUa()));
        UAData uaData = UAUtils.parseUA(device.getUa());
        deviceBuilder.setOs(OsConverter.getOsType(device.getOs(), uaData));
        deviceBuilder.setOsVersion(OsvConverter.getOsvType(device.getUa()));
        deviceBuilder.setUserAgent(optionOfNull(device.getUa()));
//        deviceBuilder.setScreenWidth(optionOfNull(device.getUa())); 屏幕宽度
//        deviceBuilder.setScreenHeight(optionOfNull(device.getUa())); 屏幕高度
//        deviceBuilder.setDpi() 每英寸像素
        //运营商 0：unkonwn；1：中国移劢；2：中国联通；3：中国电信
        deviceBuilder.setCarrier(CarrierConverter.getCarrierType(device.getCarrier()));
        deviceBuilder.setConnectionType(ConnectionTypeConverter.getConnectionType(device.getTuiaConnectionType()));
        deviceBuilder.setBrandAndModel(this.getModel(device.getMake(), uaData)); //设备品牌型号
        deviceBuilder.setIdfa(optionOfNull(device.getIdFa()));
        deviceBuilder.setIdfaMd5(optionOfNull(device.getIdFaMd5()));
        deviceBuilder.setManufacturer(this.getMaker(device.getMake(), uaData)); //设备制造商
        deviceBuilder.setOaid(optionOfNull(device.getOaId()));
        deviceBuilder.setOaidMd5(optionOfNull(device.getOaIdMd5()));
        deviceBuilder.setImei(optionOfNull(device.getImei()));
        deviceBuilder.setImeiMd5(optionOfNull(device.getImeiMd5()));
//        deviceBuilder.setInstallAppList() 用户安装app列表
        return deviceBuilder.build();
    }

    private String getModel(String model, UAData uaData) {
        if (StringUtils.isNotBlank(model)) {
            return model;
        }
        if (Objects.nonNull(uaData)) {
            String model1 = uaData.getModel();
            if (StringUtils.isNotBlank(model1)) {
                return model1;
            }
        }
        return " ";
    }

    private String getMaker(String make, UAData uaData) {
        if (StringUtils.isNotBlank(make)) {
            return make;
        }
        if (Objects.nonNull(uaData)) {
            if (Objects.equals("Android", uaData.getOsType())) {
                return "huawei";
            } else {
                return "apple";
            }
        }
        return "unknow";
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo convertGeo(CommonGeo geo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo.Builder geoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Geo.newBuilder();
        if (Objects.isNull(geo)) {
            return geoBuilder.build();
        }
        Optional.ofNullable(geo.getLat()).ifPresent(lat -> geoBuilder.setLatitude(lat.intValue()));
        Optional.ofNullable(geo.getLon()).ifPresent(leo -> geoBuilder.setLongitude(leo.intValue()));
        // accuracy， 经纬度精度半径没有
        return geoBuilder.build();
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.App convertApp(CommonAppInfo appInfo, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.App.Builder appInfoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.App.newBuilder();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            String bundle = replaceApp.getBundle();
            appInfoBuilder.setAppBundleId(bundle);
        } else {
            if (Objects.nonNull(appInfo)) {
                appInfoBuilder.setAppBundleId(appInfo.getBundle());
            } else {
                appInfoBuilder.setAppBundleId("com.tuia");
            }
        }
        return appInfoBuilder.build();
    }


    private KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression convertImp(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression.Builder impInfoBuilder = KuaishouBidRequestOuterClass.KuaishouBidRequest.Impression.newBuilder();
        List<CommonImp> impList = adxCommonBidRequest.getImpList();
        if (CollectionUtils.isEmpty(impList)) {
            return impInfoBuilder.build();
        }
        CommonImp commonImp = impList.get(0);
        impInfoBuilder.setId(optionOfNull(commonImp.getId()));
        List<CommonSizeInfo> filteringSize = filter(commonImp.getFilteringSize(), dspInfo.getAdStyleList());

        if (CollectionUtils.isNotEmpty(filteringSize)) {
            List<Long> templateIds = Lists.newArrayList();
            if (dspInfo.getDspTagId() != null) {
                impInfoBuilder.setPlacementId(dspInfo.getDspTagId());
            }
            if (dspInfo.getDspTemplateId() != null) {
                templateIds.add(Long.valueOf(dspInfo.getDspTemplateId()));
            }
            impInfoBuilder.addAllTemplateIds(templateIds);
            long bidFloor = Math.round(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100)) + 1;
            impInfoBuilder.setCpmBidFloor(bidFloor);
//            impInfoBuilder.setCpcBidFloor(bidFloor);// cpc底价
            String dspResId = dspInfo.getDspResId();
            if (StringUtils.isNumeric(dspResId)) {
                impInfoBuilder.setPlacementType(Integer.parseInt(dspResId)); //广告位类型
            }
            impInfoBuilder.addSupportCostTypes(COSTTYPE_CPM);// 计费方式
            impInfoBuilder.setAdsCount(1);// 支持返回bid个数
            impInfoBuilder.setSupportDeepLink(true);// 广告位是否支持deep link
//            List<KuaishouBidRequestOuterClass.PromotionType> collect = commonImp.getContentTypes().stream().map(this::convertPromotionType).collect(Collectors.toList());
//            impInfoBuilder.addAllPromotionTypes(collect);// 推广类型
//            impInfoBuilder.setIndustryId() // 广告位所属行业类型

            if (CollectionUtils.isEmpty(impInfoBuilder.getTemplateIdsList())) {
                log.warn("未找到对应光告广告位，commonImp {}", JSON.toJSONString(commonImp));
                return impInfoBuilder.build();
            }

        }
        impInfoBuilder.setId(commonImp.getId());

        return impInfoBuilder.build();
    }


    private List<CommonSizeInfo> filter(List<CommonSizeInfo> filteringSize, List<FilterMaterInfo> filterMaterInfos) {
        if (CollectionUtils.isEmpty(filteringSize) || CollectionUtils.isEmpty(filterMaterInfos)) {
            return null;
        }
        List<CommonSizeInfo> commonSizeInfos = Lists.newArrayList();
        for (CommonSizeInfo commonSizeInfo : filteringSize) {
            CommonSizeInfo commonSizeInfo1 = matchSizeInfo(filterMaterInfos, commonSizeInfo);
            if (Objects.nonNull(commonSizeInfo1)) {
                commonSizeInfos.add(commonSizeInfo1);
            }

        }
        return commonSizeInfos;
    }

    private CommonSizeInfo matchSizeInfo(List<FilterMaterInfo> filterMaterInfos, CommonSizeInfo commonSizeInfo) {
        int width = commonSizeInfo.getWidth();
        int height = commonSizeInfo.getHeight();
        for (FilterMaterInfo filterMaterInfo : filterMaterInfos) {
            if (filterMaterInfo.getWidth().equals(width) && filterMaterInfo.getHeight().equals(height)) {
                return commonSizeInfo;
            }
        }
        return null;
    }

    private String optionOfNull(String param) {
        return Optional.ofNullable(param).orElse("");
    }
}
