package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req;


import lombok.Data;

import java.util.List;

/**
 * imei、imei_md5、idfa、idfa_md5、oaid、oaid_md5 传值说明: 1、6 个至少传 1 个，否则视为无效请求。
 * 2、ios:idfa、idfa_md5 二选一，如果同时传递，取值优先级 idfa_md5>idfa 3、安卓:imei、imei_md5、oaid、oaid_md5 四选一，如果同时传递，取值优先级 oaid_md5 > oaid > imei_md5 > imei
 * @author Wangpf
 * @date 2022/7/1 11:40 上午
 */
@Data
public class Device {

    /**
     * 设备 user-agent
     */
    private String ua;
    /**
     * Ipv4 地址
     */
    private String ip;

    /**
     * Ipv6 地址
     */
    private String ipv6;
    /**
     * 设备类型0未知，1手机/平板 2电脑 3tv
     */
    private int devicetype;
    /**
     * 设备厂商
     */
    private String make;
    /**
     * 设备型号
     */
    private String model;
    /**
     * 操作系统
     */
    private String os;
    /**
     * 操作系统版本
     */
    private String osv;
    /**
     * 屏幕高;像素
     */
    private int h;
    /**
     * 屏幕宽;像素
     */
    private int w;
    /**
     * 联网类型
     * 0 1 2 3 4 5 6 7
     * 未知 以太网  Wifi 移动数据-未知 移动数据-2G 移动数据-3G 移动数据-4G 移动数据-5G
     */
    private int connectiontype;
    /**
     * 运营商
     */
    private String carrier;
    /**
     * 用户安卓终端的 imei 值;优先使用 imei_md5
     */
    private String imei;
    /**
     * 用户安卓终端的 imei md5 加密值。
     */
    private String imei_md5;
    /**
     * 用户安卓终端的 androidid;优先使用 androidid_md5
     */
    private String androidid;

    /**
     * 用户安卓终端的 androidid md5 加密值。
     */
    private String androidid_md5;
    /**
     * 用户苹果终端的 idfa 值;优先使用 idfa_md5
     */
    private String idfa;
    /**
     * 用户苹果终端的 idfa md5 加密值
     */
    private String idfa_md5;

    /**
     * 用户安卓终端的 oaid 值;优先使用 oaid_md5
     */
    private String oaid;
    /**
     * 用户安卓终端的 oaid md5 加密值
     */
    private String oaid_md5;
    /**
     * China Advertising Identifier for IOS
     */
    private String caid;
    /**
     * caid info list
     */
    private List<CaidInfo> caid_infos;
    /**
     * Pinduoduo Advertising Identifier-1.3
     */
    private String paid;

    /**
     * Pinduoduo Advertising Identifier-1.4
     */
    private String paid_1_4;
    /**
     * Pinduoduo Net IDentifiler
     */
    private String pnid;
    /**
     * 设备初始化时间(9 位小数) IOS
     */
    private String birth_time;
    /**
     * 系统启动时间(整数) IOS
     */
    private String boot_time;
    /**
     * 系统更新时间(6 位小数)
     */
    private String update_time;
    /**
     * 地理位置 geo 对象
     */
    private Geo geo;
    /**
     * 扩展信息.json 字符串，媒体广告平台和拼多多约定
     */
    private String ext;


}
