package cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.req;

import lombok.Data;

import java.util.List;

/**
 * @author Wangpf
 * @date 2022/7/1 11:38 上午
 */
@Data
public class Imp {

    /**
     * 该imp的曝光id
     */
    private String id;
    /**
     * 广告位标识 id，由拼多多分配
     */
    private String tagid;
    /**
     * 底价，单位:分人民币/千次曝光
     */
    private int bidfloor;
    /**
     * template 对象列表;表示流量方可以支持的模板类型
     */
    private List<Template> templates;
    /**
     * 广告类型 1.普通网址类 2.应用下载类
     */
    private List<Integer> content_type;
    /**
     * 此次曝光的点击策略 0 全局可点 1 局部可点
     */
    private Integer click_strategy;
    /**
     * 关键词，搜索广告必选
     */
    private String keyword;
    /**
     * 预定的资源 id，预留 PMP 业务使用
     */
    private String dealid;
    private List<Deal> deals;
    /**
     * 是否支持 deeplink，默认 true
     */
    private boolean support_deeplink;
    /**
     * 广告位高;像素
     */
    private Integer h;
    /**
     * 广告位宽;像素
     */
    private Integer w;
    /**
     * 广告行业黑名单
     */
    private List<String> bcat;
    /**
     * 广告行业白名单
     */
    private List<String> wcat;
    /**
     * 快应用流量标识 0 普通流量 1 快应用流量
     */
    private Integer quick_app_flow;
    /**
     * 扩展信息.json 字符串，媒体广告平台和拼多多约定
     */
    private String ext;

}
