package cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.ruangao.bean.RgyunBiddingRequest;
import cn.com.duiba.tuia.dsp.engine.api.util.UAData;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2022/10/9
 * @Description
 * @Param
 * @return
 **/

public class OsConverter {

    public static final String ANDROID = "0";
    public static final String IOS = "1";
    public static final String HARMONY_OS = "4";

    public static RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType getOsType(String os, UAData uaData){
        if(StringUtils.isBlank(os)){
            return getOsByUa(uaData);
        }
        switch (os){
            case ANDROID:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Android;
            case IOS:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Ios;
            case HARMONY_OS:
                return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Harmonyos;
            default:
                return getOsByUa(uaData);
        }
    }


    private static RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType getOsByUa(UAData uaData){
        if(Objects.isNull(uaData)){
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Unknown;
        }
        if(Objects.equals(uaData.getOsType(), "Android")){
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Android;
        }
        if(Objects.equals(uaData.getOsType(), "iOS")){
            return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Ios;
        }
        return RgyunBiddingRequest.RTBRequest.DeviceInfo.OsType.OT_Unknown;
    }
}
