package cn.com.duiba.tuia.dsp.engine.api.dsp.youku.convert;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.youku.param.*;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class RespConvert {

    public AdxCommonBidResponse convert(BidResponse bidResponse) {
        AdxCommonBidResponse response = new AdxCommonBidResponse();
        response.setRequestId(bidResponse.getId());
        response.setDspId(DspEnum.DSP_18.getDspId());
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        CommonSeatBid commonSeatBid = seatBidConvert(bidResponse.getBid().get(0));
        commonSeatBidList.add(commonSeatBid);
        response.setCommonSeatBidList(commonSeatBidList);
        return response;
    }

    private CommonSeatBid seatBidConvert(Bid bid) {
        Ad ad = bid.getAd().get(0);
        CommonSeatBid commonSeatBid = new CommonSeatBid();
        CommonContext context = new CommonContext();
        commonSeatBid.setPrice(ad.getPrice() * 1.0);
        commonSeatBid.setPriceType(0);
        commonSeatBid.setWinCallbackUrls(ad.getWnm());
        commonSeatBid.setExposureCallbackUrls(ad.getPm());
        commonSeatBid.setClickCallbackUrls(ad.getCm());
        commonSeatBid.setCommonContext(context);
        CommonCreative commonCreative = new CommonCreative();
        if (ad.getApk() != null) {
            Apk apk = ad.getApk();
            commonCreative.setAppName(apk.getApp_name());
        }
        if (ad.getLogo() != null) {
            commonCreative.setIconUrl(ad.getLogo().getUrl());
            CommonIcon commonIcon = new CommonIcon();
            commonIcon.setUrl(ad.getLogo().getUrl());
            commonCreative.setCommonIcon(commonIcon);
        }
        if (StringUtils.isNotBlank(ad.getTitle())) {
            CommonTitle commonTitle = new CommonTitle();
            commonTitle.setTitle(ad.getTitle());
            commonCreative.setCommonTitle(commonTitle);
        }
        if (StringUtils.isNotBlank(ad.getSub_title())) {
            CommonDesc commonDesc = new CommonDesc();
            commonDesc.setDesc(ad.getSub_title());
            commonCreative.setCommonDesc(commonDesc);
        }
        if (ad.getVideo() != null) {
            Video video = ad.getVideo();
            CommonVideo commonVideo = new CommonVideo();
            commonVideo.setVideoUrl(video.getUrl());
            commonVideo.setResolutionX(video.getWidth());
            commonVideo.setResolutionY(video.getHeight());
            if (video.getDuration() != null) {
                commonVideo.setDuration(BigDecimal.valueOf(video.getDuration()));
            }
            commonVideo.setSize(video.getSize());
            commonVideo.setUnit("Byte");
            commonVideo.setCoverUrl(video.getCover_image_url());
            commonVideo.setCoverWidth(video.getWidth());
            commonVideo.setCoverHeight(video.getHeight());
            commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
        } else {
            Image image = ad.getImage();
            CommonImage commonImage = new CommonImage();
            commonImage.setUrl(image.getUrl());
            commonImage.setWidth(image.getWidth());
            commonImage.setHeight(image.getHeight());
            commonCreative.setCommonImageList(Collections.singletonList(commonImage));
        }
        commonCreative.setLandingPageUrl(ad.getLdp());
        if (StringUtils.isNotBlank(ad.getDp())) {
            commonCreative.setDeepLinkUrl(ad.getDp());
            context.setDeepLinkUrl(ad.getDp());
        }
        if (StringUtils.isNotBlank(ad.getULink())) {
            commonCreative.setULinkUrl(ad.getULink());
            context.setULinkUrl(ad.getULink());
        }
        commonSeatBid.setCommonCreative(commonCreative);


        return commonSeatBid;
    }
}
