package cn.com.duiba.tuia.dsp.engine.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.net.URI;
import java.util.Map;

/**
 * @author Wangpf
 * @date 2022/7/1 3:47 下午
 */
@Component
public class CloseableHttpClientUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(CloseableHttpClientUtil.class);

    @Resource
    private CloseableHttpClient httpClient;

    /**
     * get请求
     *
     * @return
     */
    public String doGet(String url) {

        //发送get请求
        HttpGet request = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(500)
                .setSocketTimeout(500).build();
        request.setConfig(requestConfig);
        try (CloseableHttpResponse response = httpClient.execute(request)) {
            /**请求发送成功，并得到响应**/
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                /**读取服务器返回过来的json字符串数据**/
                return EntityUtils.toString(response.getEntity());
            }
        } catch (Exception e) {
            LOGGER.warn("CloseableHttpClientUtil.doGet error url is {}", url, e);
        } finally {
            request.releaseConnection();
        }

        return null;
    }

    /**
     * post请求 参数为map格式
     *
     * @param url
     * @param params
     * @return
     */
    public String doPost(String url, Map<String, Object> params) {

        // 实例化HTTP方法
        HttpPost request = new HttpPost();
        try {
            request.setURI(new URI(url));
            request.setHeader("Content-Type", "application/json; charset=utf-8");
            StringEntity s = new StringEntity(JSON.toJSONString(params));
            request.setEntity(s);

            try (CloseableHttpResponse response = httpClient.execute(request);) {//使用该编码方式，resp会在try{}块结束后自动关闭
                int code = response.getStatusLine().getStatusCode();
                //do something with resp
                if (code == HttpStatus.SC_OK) {
                    //返回json格式
                    String res = EntityUtils.toString(response.getEntity());
                    return res;
                }
            } catch (Exception ex) {
                LOGGER.warn("doPost error", ex);
            }

        } catch (Exception ex) {
            LOGGER.warn("doPost error", ex);
        } finally {
            request.releaseConnection();
        }

        return null;
    }


    /**
     * 以post方式  请求参数为json格式
     *
     * @param url
     * @param json
     * @return
     */
    public String doPost(String url, JSONObject json) {
        HttpPost post = new HttpPost(url);
        try {
            //api_gateway_auth_token自定义header头，用于token验证使用
            StringEntity s = new StringEntity(json.toString());
            s.setContentEncoding("UTF-8");
            //发送json数据需要设置contentType
            s.setContentType("application/x-www-form-urlencoded");
            //设置请求参数
            post.setEntity(s);
            try (CloseableHttpResponse response = httpClient.execute(post)) {
                if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                    //返回json格式
                    return EntityUtils.toString(response.getEntity());
                }
            }

        } catch (Exception e) {
            LOGGER.warn("CloseableHttpClientUtil.doPost error", e);
        } finally {
            post.releaseConnection();
        }

        return null;
    }
}
