package cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.convert;


import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.iqiyi.bean.IqiyiBid;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author lizhiheng
 */
@Component
@Slf4j
public class IqiyiRespConvert {

    public AdxCommonBidResponse respConvert(IqiyiBid.BidResponse response) {
        if (response == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(response.getBidList())) {
            return null;
        }
        AdxCommonBidResponse commonBidResponse = new AdxCommonBidResponse();
        commonBidResponse.setRequestId(response.getId());
        commonBidResponse.setDspId(DspEnum.DSP_16.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(response.getBidList());
        if (CollectionUtils.isEmpty(commonSeatBids)) {
            return null;
        }
        commonBidResponse.setCommonSeatBidList(commonSeatBids);
        return commonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<IqiyiBid.BidResponse.Bid> bidList) {
        List<CommonSeatBid> commonSeatBidList = new ArrayList<>();
        for (IqiyiBid.BidResponse.Bid bid : bidList) {
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext context = new CommonContext();
            CommonCreative commonCreative = new CommonCreative();
            if (bid == null) {
                continue;
            }
            commonSeatBid.setPrice((double) bid.getPrice());
            commonSeatBid.setAdvertiserId("50582");
            IqiyiBid.AdActionType action = bid.getAction();
            if (IqiyiBid.AdActionType.DOWNLOAD_APP.equals(action)) {
                return null;
            }


            //开屏
            if (bid.hasOpening()) {

                if (IqiyiBid.AdActionType.OPEN_APP_DEEPLINK.equals(action) || IqiyiBid.AdActionType.OPEN_IN_WEBVIEW.equals(action)
                        || IqiyiBid.AdActionType.OPEN_APP_UNIVERSAL_LINK.equals(action)) {
                    IqiyiBid.BidResponse.Bid.Link link = bid.getLink();
                    context.setDeepLinkUrl(link.getDeeplink());
                    commonCreative.setLandingPageUrl(link.getCurl());
                    commonSeatBid.setExposureCallbackUrls(link.getImptrackersList());
                    commonSeatBid.setClickCallbackUrls(link.getClicktrackersList());
                    if (IqiyiBid.BidResponse.Bid.CreativeType.VIDEO.equals(bid.getCreativeType())) {
                        List<CommonVideo> commonVideoList = new ArrayList<>();
                        IqiyiBid.BidResponse.Bid.AdVideo adVideo = bid.getAdVideo();
                        CommonVideo commonVideo = new CommonVideo();
                        commonVideo.setVideoUrl(bid.getAdUrl());
                        commonVideo.setDuration(new BigDecimal(adVideo.getDuration()));
                        commonVideo.setResolutionX(bid.getAdWidth());
                        commonVideo.setResolutionY(bid.getAdHeight());
                        commonVideoList.add(commonVideo);
                        commonCreative.setCommonVideoList(commonVideoList);
                    } else if (IqiyiBid.BidResponse.Bid.CreativeType.IMG.equals(bid.getCreativeType())) {
                        List<CommonImage> commonImageList = new ArrayList<>();
                        CommonImage commonImage = new CommonImage();
                        commonImage.setUrl(bid.getAdUrl());
                        commonImage.setWidth(bid.getAdWidth());
                        commonImage.setHeight(bid.getAdHeight());
                        commonImageList.add(commonImage);
                        commonCreative.setCommonImageList(commonImageList);
                    }

                }
                if (StringUtils.isNotBlank(bid.getTitle())) {
                    CommonTitle commonTitle = new CommonTitle();
                    commonTitle.setTitle(bid.getTitle());
                    commonCreative.setCommonTitle(commonTitle);
                }
                if (StringUtils.isNotBlank(bid.getDescription())) {
                    CommonDesc commonDesc = new CommonDesc();
                    commonDesc.setDesc(bid.getDescription());
                    commonCreative.setCommonDesc(commonDesc);
                }
            }
            //贴片
            if (bid.hasAdVideo()) {
                IqiyiBid.BidResponse.Bid.AdmVideo admvideo = bid.getAdmvideo();
                if (CollectionUtils.isNotEmpty(admvideo.getImgsList())) {
                    List<CommonImage> commonImageList = new ArrayList<>();
                    for (IqiyiBid.BidResponse.Bid.Image image : admvideo.getImgsList()) {
                        CommonImage commonImage = new CommonImage();
                        commonImage.setUrl(image.getUrl());
                        commonImage.setWidth(image.getW());
                        commonImage.setHeight(image.getH());
                        commonImageList.add(commonImage);
                    }
                    commonCreative.setCommonImageList(commonImageList);
                }
                if (admvideo.hasVideo()) {
                    List<CommonVideo> commonVideoList = new ArrayList<>();
                    IqiyiBid.BidResponse.Bid.Video video = admvideo.getVideo();
                    CommonVideo commonVideo = new CommonVideo();
                    commonVideo.setVideoUrl(video.getUrl());
                    commonVideo.setResolutionX(video.getW());
                    commonVideo.setResolutionY(video.getH());
                    if (video.hasDuration()) {
                        commonVideo.setDuration(new BigDecimal(video.getDuration()));
                    }
                    commonVideoList.add(commonVideo);
                    commonCreative.setCommonVideoList(commonVideoList);
                }
                if (admvideo.hasTitle()) {
                    CommonTitle commonTitle = new CommonTitle();
                    commonTitle.setTitle(admvideo.getTitle());
                    commonCreative.setCommonTitle(commonTitle);
                }
                if (admvideo.hasDesc()) {
                    CommonDesc commonDesc = new CommonDesc();
                    commonDesc.setDesc(admvideo.getDesc());
                    commonCreative.setCommonDesc(commonDesc);
                }
                commonCreative.setAppBundle(admvideo.getPackageName());
                commonCreative.setAppName(admvideo.getAppName());

            }
            //原生
            if (bid.hasAdmnative()) {
                IqiyiBid.BidResponse.Bid.AdmNative admnative = bid.getAdmnative();
                if (StringUtils.isNotBlank(admnative.getTitle())) {
                    CommonTitle commonTitle = new CommonTitle();
                    commonTitle.setTitle(admnative.getTitle());
                    commonCreative.setCommonTitle(commonTitle);
                }
                if (CollectionUtils.isNotEmpty(admnative.getImgsList())) {
                    List<CommonImage> commonImageList = new ArrayList<>();
                    for (IqiyiBid.BidResponse.Bid.Image image : admnative.getImgsList()) {
                        CommonImage commonImage = new CommonImage();
                        commonImage.setUrl(image.getUrl());
                        commonImage.setWidth(image.getW());
                        commonImage.setHeight(image.getH());
                        commonImageList.add(commonImage);
                    }
                    if (CollectionUtils.isNotEmpty(commonImageList)) {
                        commonCreative.setCommonImageList(commonImageList);
                    }
                }
                if (admnative.hasVideo()) {
                    List<CommonVideo> commonVideoList = new ArrayList<>();
                    IqiyiBid.BidResponse.Bid.Video video = admnative.getVideo();
                    CommonVideo commonVideo = new CommonVideo();
                    commonVideo.setVideoUrl(video.getUrl());
                    commonVideo.setVideoUrl(video.getUrl());
                    commonVideo.setResolutionX(video.getW());
                    commonVideo.setResolutionY(video.getH());
                    if (video.hasDuration()) {
                        commonVideo.setDuration(new BigDecimal(video.getDuration()));
                    }
                    commonVideoList.add(commonVideo);
                    commonCreative.setCommonVideoList(commonVideoList);
                }
                if (admnative.hasLink()) {
                    IqiyiBid.BidResponse.Bid.Link link = admnative.getLink();
                    context.setDeepLinkUrl(link.getDeeplink());
                    commonCreative.setLandingPageUrl(link.getCurl());
                    commonSeatBid.setExposureCallbackUrls(link.getImptrackersList());
                    commonSeatBid.setClickCallbackUrls(link.getClicktrackersList());
                }
                commonCreative.setAppBundle(admnative.getPackageName());
                commonCreative.setAppName(admnative.getAppName());
                commonCreative.setIconUrl(admnative.getAppIcon());
                if (StringUtils.isNotBlank(admnative.getAppIcon())) {
                    CommonIcon commonIcon = new CommonIcon();
                    commonIcon.setUrl(admnative.getAppIcon());
                    commonCreative.setCommonIcon(commonIcon);
                }
            }
            commonSeatBidList.add(commonSeatBid);
            commonSeatBid.setCommonContext(context);
            commonSeatBid.setCommonCreative(commonCreative);
        }

        return commonSeatBidList;
    }

}
