package cn.com.duiba.tuia.dsp.engine.api.dsp.pddzy;


import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.PddResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.constants.PddNbr;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddReqConverter;
import cn.com.duiba.tuia.dsp.engine.api.dsp.pdd.converter.PddRespConverter;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duiba.tuia.dsp.engine.api.util.CloseableHttpClientUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

import static cn.com.duiba.tuia.dsp.engine.api.exception.DspErrorCode.*;


@Component
public class PddZYDspInvoker extends AbstractDspCaller<PddResponse, PddRequest> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PddZYDspInvoker.class);

    @Resource
    PddReqConverter pddConverter;
    @Resource
    PddRespConverter pddRespConverter;

    @Resource(name = "dspRestTemplate")
    @CanAccessInsideNetwork
    private RestTemplate restTemplate;

    @Resource
    private CloseableHttpClientUtil httpClientUtil;

    @Resource
    private PddZYProperties pddZYProperties;


    @Override
    public PddRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        try {
            return pddConverter.reqConvert(adxCommonBidRequest, dspInfo);
        } catch (Exception e) {
            throw new DspException(REQ_PARAM_CONVERT_ERROR, e);
        }

    }

    @Override
    protected PddResponse invokeDsp(PddRequest pddRequest) {
        if (pddRequest == null) {
            return null;
        }
        if (pddRequest.getImp() == null || pddRequest.getImp().isEmpty()) {
            return null;
        }
        Cat.logMetricForCount("拼多多zyDSP调用");
        try {
            return CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(pddZYProperties.getUrl(), pddRequest), "invokeDSP", "pddzy");
        } catch (ResourceAccessException e) {
            throw new DspException(DSP_HTTP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Exception e) {
            throw new DspException(DSP_INVOKE_FAILED, this.getDsp(), e);
        } catch (Throwable e) {
            LOGGER.error("拼多多zy其他调用异常", e);
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(pddZYProperties.getAdxSecret().getBytes(), "AES"));
            return new String(Base64.getEncoder().encode(cipher.doFinal(price.toString().getBytes())));
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | IllegalBlockSizeException | BadPaddingException e) {
            LOGGER.warn("{} 拼多多zy价格加密失败,secret:{}", pddZYProperties.getAdxId(), pddZYProperties.getAdxSecret(), e);
            return null;
        }
    }

    /**
     * 发起http请求
     *
     * @param url
     */
    private PddResponse doHttpInvoke(String url, PddRequest pddRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity<PddRequest> requestEntity = new HttpEntity<>(pddRequest, headers);
        ResponseEntity<PddResponse> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, PddResponse.class);
        HttpStatus statusCode = resEntity.getStatusCode();
        PddResponse body = resEntity.getBody();
        if (statusCode.is2xxSuccessful()) {
            if (HttpStatus.OK.value() == statusCode.value()) {
                return this.handle2xx(body);
            } else {
                if (SamplerLog.infoFlag()){
                    SamplerLog.info("拼多多zyDSP无内容返回,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
                }
                return null;
            }
        } else if (statusCode.is5xxServerError()) {
            LOGGER.warn("拼多多zyDSP返回5xx,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
            return null;
        } else {
            LOGGER.warn("拼多多zyDSP返回其他状态码,pddRequest[{}],body[{}]", JSONObject.toJSONString(pddRequest), JSONObject.toJSONString(body));
            return null;
        }

    }

    private PddResponse handle2xx(PddResponse pddResponse) {
        if (!pddResponse.getNbr().equals(0) && SamplerLog.infoFlag()) {
            SamplerLog.info("拼多多zyDSP返回为空:{}", JSONObject.toJSONString(pddResponse));
        }
        Integer val;
        if (Objects.isNull(val = pddResponse.getNbr())) {
            return null;
        }
        if (PddNbr.NBR_0.getNbr().equals(val)) {
            Cat.logMetricForCount("拼多多zyDSP返回");
        }
        return pddResponse;
    }

    @Override
    public AdxCommonBidResponse convertResp(PddResponse pddResponse) throws DspException {
        try {
            return pddRespConverter.respConvert(pddResponse);
        } catch (Exception e) {
            throw new DspException(RESP_PARAM_CONVERT_ERROR, this.getDsp(), e);
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_19.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_19;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (url.contains("%%PRICE%%") && price != null) {
            url = url.replace("%%PRICE%%", price);
        }
        return url;
    }

    @Override
    public void doWinCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doClickCallBack(String url) {
        httpClientUtil.doGet(url);
    }

    @Override
    public void doExposureCallBack(String url) {
        httpClientUtil.doGet(url);
    }
}
