package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.*;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class JuMeiReqConvert {
    @Autowired
    private AppReplace appReplace;

    public JuMeiReq convert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        JuMeiReq juMeiReq = new JuMeiReq();
        juMeiReq.setRequestId(adxCommonBidRequest.getRequestId());
        Slot slot = slotConvert(adxCommonBidRequest, dspInfo);
        juMeiReq.setSlot(slot);
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        int bidFloor = Double.valueOf(commonImp.getFloorPrice() * (dspInfo.getMinRoi() / 100)).intValue() + 1;
        Deal deal = new Deal();
        deal.setBidfloor(bidFloor);
        juMeiReq.setDeal(deal);
        App app = appConvert(adxCommonBidRequest, dspInfo);
        juMeiReq.setApp(app);
        Device device = deviceConvert(adxCommonBidRequest, dspInfo);
        juMeiReq.setDevice(device);
        DeviceId deviceId = deviceIdConvert(adxCommonBidRequest, dspInfo);
        juMeiReq.setDeviceId(deviceId);
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        List<Caid> caids = commonDevice.getCaids();
        List<cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.Caid> jumeiCaids = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(caids)) {
            for (Caid caid : caids) {
                cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.Caid juMeiCaid = new cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.Caid();
                juMeiCaid.setCaid(caid.getId());
                juMeiCaid.setVersion(caid.getVersion());
                jumeiCaids.add(juMeiCaid);
            }

            juMeiReq.setCaids(jumeiCaids);
        }
        Network network = networkConvert(adxCommonBidRequest, dspInfo);
        juMeiReq.setNetwork(network);
        CommonGeo geo = commonDevice.getGeo();
        if (geo != null) {
            Geo juMeiGeo = new Geo();
            juMeiGeo.setLatitude(geo.getLat());
            juMeiGeo.setLongitude(geo.getLon());
            juMeiGeo.setCoordinateType(1);
            juMeiReq.setGeo(juMeiGeo);
        }
        Ext ext = new Ext();
        ext.setSupportWechat(false);
        ext.setPaid(commonDevice.getPaid());
        juMeiReq.setExt(ext);
        return juMeiReq;
    }

    private Network networkConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        Network network = new Network();
        network.setUserAgent(commonDevice.getUa());
        String ip = commonDevice.getIp();
        if (ip.contains(":")) {
            network.setIpv6(ip);
        } else {
            network.setIp(ip);
        }
        network.setMac(commonDevice.getMac());
        network.setMacMd5(commonDevice.getMacMd5());
        network.setCarrier(0);
        String carrier = commonDevice.getCarrier();
        //0:未知运营商 1:中国移动 2:中国电信 3:中国联通
        if ("1".equals(carrier)) {
            network.setCarrier(1);
        }
        if ("2".equals(carrier)) {
            network.setCarrier(3);
        }
        if ("3".equals(carrier)) {
            network.setCarrier(2);
        }
        Integer connectionType = commonDevice.getTuiaConnectionType();
        //0:unkown 1:wifi 2:2G 3:3G 4:4G 5:5G 10:以太网
        network.setNetworkType(0);
        if (connectionType == null) {
            return network;
        }
        if (connectionType == 1) {
            network.setNetworkType(10);
        }
        if (connectionType == 2) {
            network.setNetworkType(1);
        }
        if (connectionType == 4) {
            network.setNetworkType(2);
        }
        if (connectionType == 4) {
            network.setNetworkType(2);
        }
        if (connectionType == 5) {
            network.setNetworkType(3);
        }
        if (connectionType == 6) {
            network.setNetworkType(4);
        }
        if (connectionType == 7) {
            network.setNetworkType(5);
        }
        network.setCountry("CN");

        return network;
    }

    private DeviceId deviceIdConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        DeviceId deviceId = new DeviceId();
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        deviceId.setImei(commonDevice.getImei());
        deviceId.setImeiMd5(commonDevice.getImeiMd5());
        deviceId.setOaid(commonDevice.getOaId());
        deviceId.setOaidMd5(commonDevice.getOaIdMd5());
        deviceId.setAndroidId(commonDevice.getDpId());
        deviceId.setAndroidIdMd5(commonDevice.getDpIdMd5());
        deviceId.setIdfa(commonDevice.getIdFa());
        deviceId.setIdfaMd5(commonDevice.getIdFaMd5());
        deviceId.setIdfv(commonDevice.getIdfv());
        return deviceId;
    }

    private Device deviceConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        Device device = new Device();
        //0:Unknown 1:IOS 2:Android 5:Windows 7:HarmonyOs
        String os = commonDevice.getOs();
        device.setOsType(0);
        if ("0".equals(os)) {
            device.setOsType(2);
        }
        if ("1".equals(os)) {
            device.setSupportUniversal(1);
            device.setOsType(1);
        }
        if ("2".equals(os)) {
            device.setOsType(5);
        }
        if ("4".equals(os)) {
            device.setOsType(7);
        }
        device.setType(1);
        device.setOsVersion(commonDevice.getOsVersion());
        device.setSysCompilingTime(commonDevice.getBirthTime());
        device.setSysUpdateTime(commonDevice.getUpdateTime());
        device.setSysStartupTime(commonDevice.getBootTime());
        device.setModel(commonDevice.getModel());
        device.setSupportDeeplink(1);
        device.setMake(commonDevice.getMake());
        device.setOrientation(0);
        return device;
    }

    private App appConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        App app = new App();
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        if (replaceApp != null) {
            app.setName(replaceApp.getName());
            app.setPkgName(replaceApp.getBundle());
        } else {
            app.setName(appInfo.getName());
            app.setPkgName(appInfo.getBundle());
        }
        return app;
    }

    private Slot slotConvert(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        Slot slot = new Slot();
        slot.setAdSlotId(Integer.parseInt(dspInfo.getDspTagId()));
        slot.setType(Integer.parseInt(dspInfo.getDspResId()));
        CommonImp commonImp = adxCommonBidRequest.getImpList().get(0);
        CommonSizeInfo commonSizeInfo = commonImp.getFilteringSize().get(0);
        slot.setWidth(commonSizeInfo.getWidth());
        slot.setHeight(commonSizeInfo.getHeight());
        return slot;
    }
}
