/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong;

import com.google.common.base.Charsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DigestAuthUtil {
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final String USERTYPE = "1";

    public static String getPostReqDigestHeader(String uri, String workKey, String appId, String keyId) {
        Long nonce = System.currentTimeMillis();
        StringBuilder digestSb = new StringBuilder();
        digestSb.append(nonce).append(":").append("POST").append(":").append(uri);
        String key = appId + ":" + uri.substring(1) + ":" + workKey;
        String digest = DigestAuthUtil.encryptHMACStr(digestSb.toString(), key.getBytes(Charsets.UTF_8), "HmacSHA256");
        String authDigest = DigestAuthUtil.getAuthorzationRegexORData(appId, uri.substring(1), String.valueOf(nonce), digest, "HmacSHA256", keyId);
        return authDigest;
    }

    public static String encryptHMACStr(String data, byte[] key, String algorithm) {
        if (null == data) {
            return null;
        }
        byte[] bytes = DigestAuthUtil.encryptHMAC(data.getBytes(org.apache.commons.codec.Charsets.UTF_8), key, algorithm);
        if (null == bytes) {
            return null;
        }
        return DigestAuthUtil.byteArrayToHexString(bytes);
    }

    public static byte[] encryptHMAC(byte[] data, byte[] key, String algorithm) {
        SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
        byte[] bytes = null;
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    private static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(DigestAuthUtil.byteToHexString(bytes[i]));
        }
        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int ret = b;
        if (ret < 0) {
            ret += 256;
        }
        int m = ret / 16;
        int n = ret % 16;
        return HEX_DIGITS[m] + HEX_DIGITS[n];
    }

    public static String getAuthorzationRegexORData(String appId, String realm, String nonce, String response, String algorithm, String keyId) {
        StringBuilder regex = new StringBuilder(150);
        regex.append("Digest ").append("username").append("=").append(appId).append(",").append("realm").append("=").append(realm).append(",").append("nonce").append("=").append(nonce).append(",").append("response").append("=").append(response).append(",").append("algorithm").append("=").append(algorithm).append(",").append("usertype").append("=").append(USERTYPE).append(",").append("keyid").append("=").append(keyId);
        return regex.toString();
    }

    public static void main(String[] args) {
        String signKey = "8a0558d88dd26c195e6de487ca794ee900e90614e5673a613e74150c504f5849";
        String publishId = "1298627449743028224";
        String realm = "/ppsadx/getResult";
        String keyId = "3";
        try {
            String del = DigestAuthUtil.getPostReqDigestHeader(realm, signKey, publishId, keyId);
            System.out.println(del);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

