/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.jumei;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.JuMeiProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.JuMeiReq;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.bean.JuMeiResp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert.JuMeiReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jumei.convert.JuMeiRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class JuMeiDspInvoker
extends AbstractDspCaller<JuMeiResp, JuMeiReq> {
    private static final Logger log = LoggerFactory.getLogger(JuMeiDspInvoker.class);
    @Autowired
    private JuMeiReqConvert juMeiReqConvert;
    @Autowired
    private JuMeiRespConvert juMeiRespConvert;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private JuMeiProperties juMeiProperties;

    @Override
    protected JuMeiResp invokeDsp(JuMeiReq juMeiReq) {
        if (juMeiReq == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u805a\u5a92DSP\u8c03\u7528");
        try {
            return (JuMeiResp)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.juMeiProperties.getUrl(), juMeiReq), (String)"invokeDSP", (String)"jumei");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u805a\u5a92_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u805a\u5a92\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private JuMeiResp doHttpInvoke(String url, JuMeiReq juMeiReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)juMeiReq, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, JuMeiResp.class, new Object[0]);
        }
        catch (Exception e) {
            log.warn("\u805a\u5a92\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        if (responseEntity == null) {
            return null;
        }
        JuMeiResp body = (JuMeiResp)responseEntity.getBody();
        if (body != null && body.getCode() == 200) {
            Cat.logMetricForCount((String)"\u805a\u5a92DSP\u8fd4\u56de");
            return body;
        }
        return null;
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        return price.toString();
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_15.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_15;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            return url.replace("__MF_LOSS_PR__", price);
        }
        return url;
    }

    @Override
    public JuMeiReq convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.juMeiReqConvert.convert(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(JuMeiResp juMeiResp) throws DspException {
        if (juMeiResp != null && juMeiResp.getCode() == 200) {
            return this.juMeiRespConvert.convert(juMeiResp);
        }
        return null;
    }
}

