/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.baidu;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AbstractDspCaller;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.BaiDuDspProperties;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.convert.BaiDuDspReqConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.convert.BaiDuDspRespConvert;
import cn.com.duiba.tuia.dsp.engine.api.dsp.baidu.proto.BaiDuDsp;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.AdxCommonBidRequest;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.DspInfo;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import cn.com.duiba.tuia.dsp.engine.api.exception.DspException;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class BaiDuDspInvoker
extends AbstractDspCaller<BaiDuDsp.Response, BaiDuDsp.Request> {
    private static final Logger log = LoggerFactory.getLogger(BaiDuDspInvoker.class);
    @Autowired
    private BaiDuDspReqConvert baiDuDspReqConvert;
    @Autowired
    private BaiDuDspRespConvert baiDuDspRespConvert;
    @Autowired
    private BaiDuDspProperties baiDuDspProperties;
    @Resource(name="dspRestTemplate")
    private RestTemplate restTemplate;

    @Override
    protected BaiDuDsp.Response invokeDsp(BaiDuDsp.Request request) {
        if (request == null) {
            return null;
        }
        Cat.logMetricForCount((String)"\u767e\u5ea6DSP\u8c03\u7528");
        try {
            return (BaiDuDsp.Response)CatUtils.executeInCatTransaction(() -> this.doHttpInvoke(this.baiDuDspProperties.getBaiduDspUrl(), request), (String)"invokeDSP", (String)"baiduDsp");
        }
        catch (Throwable t) {
            Cat.logMetricForCount((String)"\u767e\u5ea6dsp_\u7ade\u4ef7\u5931\u8d25");
            if (!(t instanceof RestClientException) && !(t instanceof SocketTimeoutException)) {
                SamplerLog.warn((String)"\u767e\u5ea6dsp\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{t});
            }
            return null;
        }
    }

    private BaiDuDsp.Response doHttpInvoke(String url, BaiDuDsp.Request request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-protobuf;charset=UTF-8");
        HttpEntity entity = new HttpEntity((Object)request.toByteArray(), (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class, new Object[0]);
        }
        catch (Exception e) {
            if (!(e instanceof RestClientException)) {
                SamplerLog.warn((String)"\u767e\u5ea6dsp\u8c03\u7528\u5f02\u5e38", (Object[])new Object[]{e});
            }
            return null;
        }
        byte[] body = (byte[])responseEntity.getBody();
        if (body == null) {
            return null;
        }
        try {
            BaiDuDsp.Response response = BaiDuDsp.Response.parseFrom(body);
            if (CollectionUtils.isEmpty(response.getSeatbidList())) {
                return null;
            }
            Cat.logMetricForCount((String)"\u767e\u5ea6DSP\u8fd4\u56de");
            return response;
        }
        catch (Exception e) {
            log.warn("\u767e\u5ea6dsp\u8c03\u7528\u5f02\u5e38 ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String priceEncryption(BigDecimal price) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(this.baiDuDspProperties.getSecret().getBytes(StandardCharsets.UTF_8), "AES"));
            byte[] encryptedData = cipher.doFinal(price.toString().getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(encryptedData);
        }
        catch (Exception e) {
            log.warn("priceEncryption error", (Throwable)e);
            return "";
        }
    }

    @Override
    protected Integer getDspId() {
        return DspEnum.DSP_27.getDspId();
    }

    @Override
    protected DspEnum getDsp() {
        return DspEnum.DSP_27;
    }

    @Override
    protected String replaceUrl(String price, String url) {
        if (StringUtils.isNotBlank((CharSequence)price)) {
            return url.replaceAll("__WIN_PRICE_SECURE__", price);
        }
        return url;
    }

    @Override
    public BaiDuDsp.Request convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) throws DspException {
        return this.baiDuDspReqConvert.convertReq(adxCommonBidRequest, dspInfo);
    }

    @Override
    public AdxCommonBidResponse convertResp(BaiDuDsp.Response response) throws DspException {
        if (response == null || CollectionUtils.isEmpty(response.getSeatbidList())) {
            return null;
        }
        return this.baiDuDspRespConvert.convert(response);
    }
}

