package cn.com.duiba.tuia.dsp.engine.api.dsp.common.req;

import lombok.Data;

import java.util.List;

@Data
public class DspInfo {
    /**
     * 计划id
     */
    private Long ideaId;

    /**
     * Dsp 平台Id
     */
    private Integer dspId;

    /**
     * dsp 模版id
     */
    private String dspTemplateId;

    /**
     * dsp 广告位id
     */
    private String dspTagId;

    /**
     * dsp 资源位id
     */
    private String dspResId;
    /**
     * 广告计划id
     */
    private Long advertId;
    /**
     * 创意计划适合的宽高
     */
    private List<FilterMaterInfo> adStyleList;

    private Boolean notLimit;

    //创意的roi
    private Double minRoi;

    /**
     * 资源位id
     */
    private Long resourceId;

    /**
     * adx推广组id
     */
    private Long groupId;

    /**
     * dsp底价
     * 0 动态底价 表示系数
     * 1 固定底价 表示表示价格
     */
    private Integer dspFloorPrice;

    /**
     * cpc计费 0-关闭 1-开启
     */
    private int cpcCharge;

    /**
     * dsp底价类型 0动态底价 1固定底价
     */
    private Integer dspFloorType;
}
