package cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.convert;

import cn.com.duiba.tuia.adx.center.api.common.Caid;
import cn.com.duiba.tuia.dsp.engine.api.dsp.AppReplace;
import cn.com.duiba.tuia.dsp.engine.api.dsp.CalculateFloorPrice;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.req.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.AdxCommonBidResponse;
import cn.com.duiba.tuia.dsp.engine.api.dsp.feisuo.proto.FeiSuoProtoBid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class FeiSuoDspReqConvert {
    @Autowired
    private AppReplace appReplace;

    public FeiSuoProtoBid.FlyingShuttleBidRequest convertReq(AdxCommonBidRequest adxCommonBidRequest, DspInfo dspInfo) {
        FeiSuoProtoBid.FlyingShuttleBidRequest.Builder builder = FeiSuoProtoBid.FlyingShuttleBidRequest.newBuilder();
        //TODO 测试环境token
        builder.setToken("1yh0ryt83i0czmcsugsk98q64kr7g24u");
        builder.setRequestId(adxCommonBidRequest.getRequestId());
        builder.setTimestamp(System.currentTimeMillis());

        //用户信息
        CommonUserInfo userInfo = adxCommonBidRequest.getUserInfo();
        if (userInfo != null && CollectionUtils.isNotEmpty(userInfo.getAppList())) {
            List<Integer> installedApps = convertInstallApp(userInfo.getAppList());
            if (CollectionUtils.isNotEmpty(installedApps)) {
                FeiSuoProtoBid.User.Builder user = FeiSuoProtoBid.User.newBuilder();
                user.addAllInstalledApps(installedApps);
                builder.setUser(user);
            }
        }
        //广告位信息
        List<CommonImp> commonImps = adxCommonBidRequest.getImpList();
        CommonImp commonImp = commonImps.get(0);
        FeiSuoProtoBid.Slot slot = convertSlot(commonImp, dspInfo);
        builder.setSlot(slot);

        //设备信息
        CommonDevice commonDevice = adxCommonBidRequest.getDevice();
        FeiSuoProtoBid.Device device = convertDevice(commonDevice);
        builder.setDevice(device);

        //app信息
        CommonAppInfo appInfo = adxCommonBidRequest.getAppInfo();
        FeiSuoProtoBid.SourceApp sourceApp = convertAppInfo(appInfo, dspInfo);
        builder.setApp(sourceApp);

        //网络信息
        FeiSuoProtoBid.Network.Builder network = convertNetwork(commonDevice);
        builder.setNetwork(network);

        //geo信息
        CommonGeo commonGeo = commonDevice.getGeo();
        if (commonGeo != null) {
            builder.setGeo(convertGeo(commonGeo));
        }

        return builder.build();
    }

    private FeiSuoProtoBid.Geo convertGeo(CommonGeo commonGeo) {
        FeiSuoProtoBid.Geo.Builder geo = FeiSuoProtoBid.Geo.newBuilder();
        geo.setLatitude(commonGeo.getLat());
        geo.setLongitude(commonGeo.getLon());
        return geo.build();
    }

    private FeiSuoProtoBid.Network.Builder convertNetwork(CommonDevice commonDevice) {
        FeiSuoProtoBid.Network.Builder network = FeiSuoProtoBid.Network.newBuilder();
        Integer tuiaConnectionType = commonDevice.getTuiaConnectionType();
        network.setType(FeiSuoProtoBid.NetType.NET_TYPE_UNSPECIFIED);
        if (tuiaConnectionType != null) {
            if (tuiaConnectionType == 1) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_ETHERNET);
            }
            if (tuiaConnectionType == 2) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_WIFI);
            }
            if (tuiaConnectionType == 3) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_UNKNOWN);
            }
            if (tuiaConnectionType == 4) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_2G);
            }
            if (tuiaConnectionType == 5) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_3G);
            }
            if (tuiaConnectionType == 6) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_4G);
            }
            if (tuiaConnectionType == 7) {
                network.setType(FeiSuoProtoBid.NetType.NET_TYPE_CELLULAR_5G);
            }
        }
        String carrier = commonDevice.getCarrier();
        network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_UNSPECIFIED);
        if (StringUtils.isNotBlank(carrier)) {
            if ("1".equals(carrier)) {
                //移动
                network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_MOBILE);
            } else if ("2".equals(carrier)) {
                //联通
                network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_UNICOM);
            } else if ("3".equals(carrier)) {
                //电信
                network.setCarrier(FeiSuoProtoBid.Carrier.CARRIER_TELECOM);
            }
        }
        network.setIpv4(commonDevice.getIp());

        return network;
    }

    private FeiSuoProtoBid.SourceApp convertAppInfo(CommonAppInfo appInfo, DspInfo dspInfo) {
        CommonAppInfo replaceApp = appReplace.getReplaceApp(dspInfo.getIdeaId());
        FeiSuoProtoBid.SourceApp.Builder app = FeiSuoProtoBid.SourceApp.newBuilder();
        if (replaceApp != null) {
            appInfo = replaceApp;
        }
        //TODO 测试环境appId
        app.setId("TEST");
        app.setName(appInfo.getName());
        app.setPkgName(appInfo.getBundle());
        return app.build();
    }

    private FeiSuoProtoBid.Device convertDevice(CommonDevice commonDevice) {
        FeiSuoProtoBid.Device.Builder builder = FeiSuoProtoBid.Device.newBuilder();
        Integer tuiaDeviceType = commonDevice.getTuiaDeviceType();
        if (tuiaDeviceType != null) {
            builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_UNSPECIFIED);
            if (tuiaDeviceType == 1) {
                builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_PHONE);
            }
            if (tuiaDeviceType == 2) {
                builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_PC);
            }
            if (tuiaDeviceType == 3) {
                builder.setType(FeiSuoProtoBid.DeviceType.DEVICE_TYPE_TV);
            }
        }
        String os = commonDevice.getOs();
        if ("1".equals(os)) {
            builder.setOs(FeiSuoProtoBid.OS.OS_IOS);
        } else if ("0".equals(os)) {
            builder.setOs(FeiSuoProtoBid.OS.OS_ANDROID);
        }
        if (StringUtils.isNotBlank(commonDevice.getOsVersion())) {
            builder.setOsVersion(commonDevice.getOsVersion());
        }
        if (StringUtils.isNotBlank(commonDevice.getMake())) {
            builder.setVendor(commonDevice.getMake());
        }
        if (StringUtils.isNotBlank(commonDevice.getModel())) {
            builder.setModel(commonDevice.getModel());
        }
        if (StringUtils.isNotBlank(commonDevice.getUa())) {
            builder.setUserAgent(commonDevice.getUa());
        }
        builder.setScreenWidth(commonDevice.getScreenWidth());
        builder.setScreenHeight(commonDevice.getScreenHeight());
        builder.setScreenPpi(commonDevice.getPpi());
        if (StringUtils.isNotBlank(commonDevice.getBootTime())) {
            builder.setBootTime(commonDevice.getBootTime());
        }
        if (StringUtils.isNotBlank(commonDevice.getUpdateTime())) {
            builder.setSysUpdateTime(commonDevice.getUpdateTime());
        }
        if (StringUtils.isNotBlank(commonDevice.getHmsCoreVersion())) {
            builder.setHwHmsVerCode(commonDevice.getHmsCoreVersion());
        }
        if (StringUtils.isNotBlank(commonDevice.getAgVerCode())) {
            builder.setHwAgVerCode(commonDevice.getAgVerCode());
        }
        FeiSuoProtoBid.DeviceID.Builder deviceID = FeiSuoProtoBid.DeviceID.newBuilder();
        if (StringUtils.isNotBlank(commonDevice.getImei())) {
            deviceID.setImei(commonDevice.getImei());
        }
        if (StringUtils.isNotBlank(commonDevice.getDpId())) {
            deviceID.setAndroidId(commonDevice.getDpId());
        }
        if (StringUtils.isNotBlank(commonDevice.getMac())) {
            deviceID.setMac(commonDevice.getMac());
        }
        if (StringUtils.isNotBlank(commonDevice.getOaId())) {
            deviceID.setOaid(commonDevice.getOaId());
        }
        if (StringUtils.isNotBlank(commonDevice.getIdFa())) {
            deviceID.setIdfa(commonDevice.getIdFa());
        }
        if (StringUtils.isNotBlank(commonDevice.getOaIdMd5())) {
            deviceID.setOaidMd5(commonDevice.getOaIdMd5());
        }
        if (StringUtils.isNotBlank(commonDevice.getImeiMd5())) {
            deviceID.setImeiMd5(commonDevice.getImeiMd5());
        }
        if (StringUtils.isNotBlank(commonDevice.getIdFaMd5())) {
            deviceID.setIdfaMd5(commonDevice.getIdFaMd5());
        }
        if (CollectionUtils.isNotEmpty(commonDevice.getCaids())) {
            for (Caid caid : commonDevice.getCaids()) {
                FeiSuoProtoBid.CAID.Builder caidBuilder = FeiSuoProtoBid.CAID.newBuilder();
                caidBuilder.setCaid(caid.getId());
                caidBuilder.setVersion(caid.getVersion());
                deviceID.addCaids(caidBuilder);
            }
        }
        return builder.build();
    }

    private FeiSuoProtoBid.Slot convertSlot(CommonImp commonImp, DspInfo dspInfo) {
        FeiSuoProtoBid.Slot.Builder builder = FeiSuoProtoBid.Slot.newBuilder();
        builder.setId(dspInfo.getDspTagId());
        builder.setType(FeiSuoProtoBid.SlotType.forNumber(Integer.parseInt(dspInfo.getDspResId())));
        builder.setAdCount(1);
        builder.addMaterialTypes(FeiSuoProtoBid.MaterialType.forNumber(Integer.parseInt(dspInfo.getDspTemplateId())));
        long floorPrice = CalculateFloorPrice.getFloorPrice(commonImp.getFloorPrice(), dspInfo);
        builder.setFloorCpm((int) floorPrice);

        return builder.build();
    }

    private List<Integer> convertInstallApp(List<String> appList) {
        return appList.stream().map(FeiSuoAppConvert::convert).filter(Objects::nonNull).collect(Collectors.toList());
    }


}
