package cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.common.resp.*;
import cn.com.duiba.tuia.dsp.engine.api.dsp.jinghong.bean.Jinghong;
import cn.com.duiba.tuia.dsp.engine.api.enums.DspEnum;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @Author yuquanfeng
 * @Date 2022/9/30
 * @Description
 * @Param
 * @return
 **/
@Component
public class JinghongResponseConverter {

    public AdxCommonBidResponse respConvert(Jinghong.AdResponse rtbResponse) {
        if (Objects.isNull(rtbResponse)) {
            return null;
        }
        AdxCommonBidResponse adxCommonBidResponse = new AdxCommonBidResponse();
        adxCommonBidResponse.setDspId(DspEnum.DSP_24.getDspId());
        List<CommonSeatBid> commonSeatBids = seatConvert(rtbResponse.getMultiad(), rtbResponse.getDspcost());
        adxCommonBidResponse.setCommonSeatBidList(commonSeatBids);
        return adxCommonBidResponse;
    }

    private List<CommonSeatBid> seatConvert(List<Jinghong.Ad> adList, Integer dspcost) {
        List<CommonSeatBid> commonSeatBidList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(adList)) {
            return commonSeatBidList;
        }

        // 获取第一个广告位的广告信息
        Jinghong.Ad firstAd = adList.get(0);
        List<Jinghong.Content> adContentList = firstAd.getContent();
        String soltId = firstAd.getSlotid();
        // 遍历所有广告位
        for (Jinghong.Content adContent : adContentList) {
            Jinghong.MetaData metaData = adContent.getMetaData();
            // 2下载
            Integer interactiontype = adContent.getInteractiontype();

            // 遍历广告位中的广告
            CommonSeatBid commonSeatBid = new CommonSeatBid();
            CommonContext commonContext = new CommonContext();
            commonSeatBid.setCommonContext(commonContext);
            // 设置基础信息（与工程中其他DSP保持相同结构）
            commonSeatBid.setAdvertiserId("44910"); // 固定值与其他DSP对齐
            // 构建创意信息
            CommonCreative commonCreative = new CommonCreative();
            commonCreative.setMaterialId(adContent.getContentid());
//            commonSeatBid.setPriceType(0);
            commonSeatBid.setPrice(adContent.getPrice() != null ? Double.valueOf(adContent.getPrice()) : 0);
            // 标题处理
            CommonTitle commonTitle = new CommonTitle();
            commonCreative.setCommonTitle(commonTitle);
            Jinghong.ApkInfo apkInfo = metaData.getApkInfo();
            if (apkInfo != null) {
                commonCreative.setAppBundle(apkInfo.getPackageName());
                commonCreative.setIconUrl(apkInfo.getAppIcon());
                commonCreative.setPrivacyPolicyLink(metaData.getPrivacyUrl());
                commonCreative.setPermissionLink(apkInfo.getPermissionUrl());
                commonCreative.setAppVersion(apkInfo.getVersionCode());
                commonCreative.setIconUrl(apkInfo.getAppIcon());
                commonCreative.setDeveloper(apkInfo.getDeveloperName());
                CommonIcon commonIcon = new CommonIcon();
                commonIcon.setUrl(apkInfo.getAppIcon());
                commonCreative.setCommonIcon(commonIcon);
                CommonDesc commonDesc = new CommonDesc();
                try {
                    if (StringUtils.isNotBlank(apkInfo.getAppName())) {
                        commonCreative.setAppName(URLDecoder.decode(apkInfo.getAppName(), "UTF-8"));
                    }
                    if (StringUtils.isNotBlank(apkInfo.getAppDesc())) {
                        commonDesc.setDesc(URLDecoder.decode(apkInfo.getAppDesc(), "UTF-8"));
                    }
                    if (StringUtils.isNotBlank(metaData.getTitle())) {
                        commonTitle.setTitle(URLDecoder.decode(metaData.getTitle(), "UTF-8"));
                    }

                } catch (Exception e) {
                    //
                }
                commonCreative.setCommonDesc(commonDesc);
                //下载类预算 设置下载地址
                if (interactiontype == 2) {
                    commonCreative.setDownloadUrl(apkInfo.getUrl());
                }
                if (apkInfo.getAppDesc() != null) {
                    try {
                        commonCreative.setAppFeature(URLDecoder.decode(apkInfo.getAppDesc(), "UTF-8"));
                    } catch (UnsupportedEncodingException e) {
                        // ignore
                    }
                }
            }

            if (metaData.getIntent() != null) {

                try {

                    String intent = metaData.getIntent();
                    if (StringUtils.isNotBlank(intent)) {

                        String dbLink = intent;
                        if (!intent.startsWith("hwpps://landingpage")) {
                            dbLink = URLDecoder.decode(metaData.getIntent(), "UTF-8");
                        }

                        commonCreative.setDeepLinkUrl(dbLink);
                        commonContext.setDeepLinkUrl(dbLink);
                        commonSeatBid.setCommonContext(commonContext);
                    }

                } catch (Exception e) {
                    //ignore
                }
            }
            commonCreative.setLandingPageUrl(metaData.getClickUrl());
            if (StringUtils.isBlank(commonCreative.getLandingPageUrl())) {
                commonCreative.setLandingPageUrl("https://developer.huawei.com/consumer/cn/huawei-quickApp");
            }

            // 视频处理
            Jinghong.VideoInfo video = metaData.getVideoInfo();
            if (video != null) {
                CommonVideo commonVideo = new CommonVideo();
                commonVideo.setVideoUrl(video.getVideoDownloadUrl());
                commonVideo.setDuration(new BigDecimal(video.getVideoDuration() / 1000));
                commonVideo.setSize(video.getVideoFileSize());
                commonCreative.setCommonVideoList(Collections.singletonList(commonVideo));
                if (CollectionUtils.isNotEmpty(metaData.getImageInfo())) {
                    Jinghong.ImageInfo imageInfo = metaData.getImageInfo().get(0);
                    commonVideo.setCoverUrl(imageInfo.getUrl());
                    commonVideo.setCoverWidth(imageInfo.getWidth());
                    commonVideo.setCoverHeight(imageInfo.getHeight());
                }
            }

            // 图片处理
            List<Jinghong.ImageInfo> images = metaData.getImageInfo();
            if (CollectionUtils.isNotEmpty(images)) {

                List<CommonImage> commonImageList = Lists.newArrayList();
                for (Jinghong.ImageInfo image : images) {
                    CommonImage commonImage = new CommonImage();
                    commonImage.setUrl(image.getUrl());
                    commonImage.setWidth(image.getWidth());
                    commonImage.setHeight(image.getHeight());
                    commonImage.setSize(image.getFileSize());
                    commonImageList.add(commonImage);
                }
                commonCreative.setCommonImageList(commonImageList);
            }

            List<Jinghong.Monitor> monitors = adContent.getMonitor();
            // 设置回调URL
            commonSeatBid.setWinCallbackUrls(Collections.singletonList(adContent.getNurl()));
            for (Jinghong.Monitor monitor : monitors) {

                switch (monitor.getEventType()) {
                    case "imp":
                        commonSeatBid.setExposureCallbackUrls(monitor.getUrl());
                        break;
                    case "click":
                        commonSeatBid.setClickCallbackUrls(monitor.getUrl());
                        break;
                    case "downloadstart":
                        commonSeatBid.setStartDownloadUrls(monitor.getUrl());
                        break;
                    case "download":
                        commonSeatBid.setFinishDownloadUrls(monitor.getUrl());
                        break;
                    case "install":
                        commonSeatBid.setFinishInstallUrls(monitor.getUrl());
                        break;
                    case "intentSuccess":
                        commonSeatBid.setDeeplinkSuccessUrls(monitor.getUrl());
                        break;
                    case "userclose":
                        commonSeatBid.setCloseAdUrls(monitor.getUrl());
                        break;
                    case "appOpen":
                        commonSeatBid.setAppOpenUrls(monitor.getUrl());
                        break;
                }
            }


            commonSeatBid.setCommonCreative(commonCreative);
            commonSeatBidList.add(commonSeatBid);
        }

        return commonSeatBidList;
    }

}
