/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.converter;

import cn.com.duiba.tuia.dsp.engine.api.dsp.kuaishou.bean.KuaishouBidRequestOuterClass;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DeviceTypeConverter {
    private static final Pattern PATTERN_IPHONE = Pattern.compile("\\((iPhone);(.+?)\\)");
    private static final Pattern PATTERN_IPAD = Pattern.compile("(iPad).*OS\\s([\\d_]+)");
    private static final Pattern PATTERN_ANDROID = Pattern.compile(";\\s?(((\\d|[a-z]|[A-Z]|-|_)*?\\s)*?)(Build)?/");
    private static final Pattern HARMONYOS = Pattern.compile("HarmonyOS;\\s?(\\S*)");
    private static final Pattern HARMONYOS2 = Pattern.compile(";\\s?(\\S*); HMSCore");

    public static KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType getDeviceType(String ua) {
        if (StringUtils.isBlank((CharSequence)ua)) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType.DEVICETYPE_MOBILE;
        }
        if (PATTERN_IPHONE.matcher(ua).find()) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType.DEVICETYPE_MOBILE;
        }
        if (PATTERN_IPAD.matcher(ua).find()) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType.DEVICETYPE_PAD;
        }
        if (DeviceTypeConverter.isAndroid(ua)) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType.DEVICETYPE_MOBILE;
        }
        if (ua.contains("Windows") || ua.contains("Mac")) {
            return KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType.DEVICETYPE_PC;
        }
        return KuaishouBidRequestOuterClass.KuaishouBidRequest.DeviceType.DEVICETYPE_MOBILE;
    }

    private static boolean isAndroid(String ua) {
        if (PATTERN_ANDROID.matcher(ua).find() || HARMONYOS.matcher(ua).find() || HARMONYOS2.matcher(ua).find()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

